% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tpm_functions.R
\name{tpm_cont}
\alias{tpm_cont}
\title{Calculate continuous time transition probabilities}
\usage{
tpm_cont(Q, timediff, ad = NULL, report = TRUE)
}
\arguments{
\item{Q}{infinitesimal generator matrix of the continuous-time Markov chain of dimension c(N,N)}

\item{timediff}{time differences between observations of length n-1 when based on n observations}

\item{ad}{optional logical, indicating whether automatic differentiation with \code{RTMB} should be used. By default, the function determines this itself.}

\item{report}{logical, indicating whether \code{Q} should be reported from the fitted model. Defaults to \code{TRUE}, but only works if \code{ad = TRUE}.}
}
\value{
array of continuous-time transition matrices of dimension c(N,N,n-1)
}
\description{
A continuous-time Markov chain is described by an infinitesimal generator matrix \eqn{Q}. 
When observing data at time points \eqn{t_1, \dots, t_n} the transition probabilites between \eqn{t_i} and \eqn{t_{i+1}} are caluclated as
\deqn{\Gamma(\Delta t_i) = \exp(Q \Delta t_i),}
where \eqn{\exp()} is the matrix exponential. The mapping \eqn{\Gamma(\Delta t)} is also called the \strong{Markov semigroup}.
This function calculates all transition matrices based on a given generator and time differences.
}
\examples{
# building a Q matrix for a 3-state cont.-time Markov chain
Q = generator(rep(-2, 6))

# draw random time differences
timediff = rexp(100, 10)

# compute all transition matrices
Gamma = tpm_cont(Q, timediff)
}
\seealso{
Other transition probability matrix functions: 
\code{\link{generator}()},
\code{\link{tpm}()},
\code{\link{tpm_emb}()},
\code{\link{tpm_emb_g}()},
\code{\link{tpm_g}()},
\code{\link{tpm_g2}()},
\code{\link{tpm_p}()}
}
\concept{transition probability matrix functions}
