% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LassoBT.R
\name{LassoBT}
\alias{LassoBT}
\title{Fit linear models with interactions using the Lasso.}
\usage{
LassoBT(
  x,
  y,
  nlambda = 100L,
  iter_max = 1L,
  lambda.min.ratio = ifelse(nobs < nvars, 0.01, 1e-04),
  lambda = NULL,
  thresh = 1e-07,
  verbose = FALSE,
  inter_orig
)
}
\arguments{
\item{x}{input matrix of dimension nobs by nvars; each row is an observation
vector.}

\item{y}{response variable; shoud be a numeric vector.}

\item{nlambda}{the number of lambda values. Must be at least 3.}

\item{iter_max}{the number of iterations of the Backtracking algorithm to
run. \code{iter_max=1} corresponds to a single lasso or elasticnet fit.
Values greater than 1 will fit interactions.}

\item{lambda.min.ratio}{smallest value in \code{lambda} as a fraction of the
largest value at which all main effects coefficients are 0.}

\item{lambda}{user supplied \code{lambda} sequence of decreasing penalty
parameters. Typical usage is to allow the function to compute its own
\code{lambda} sequence. Inappropriate sequences may cause convergence
problems.}

\item{thresh}{convergence threshold for coordinate descent. Each inner
coordinate descent loop continues until either the maximum change in the
objective after any coefficient update is less than \code{thresh} or
\code{1E5} iterations have been performed.}

\item{verbose}{if \code{TRUE} will print iteration numbers.}

\item{inter_orig}{an optional 2-row matrix with each column giving
interactions that are to be added to the design matrix before the algorithm
begins.}
}
\value{
An object with S3 class "\code{BT}".
 \describe{ 
  \item{\code{call}}{the call that produced the object}
  \item{\code{a0}}{list of intercept vectors}
  \item{\code{beta}}{list of matrices of coefficients
  stored in sparse column format (\code{CsparseMatrix})} 
  \item{\code{fitted}}{list of fitted values}
  \item{\code{lambda}}{the sequence of \code{lambda} values used}
  \item{\code{nobs}}{the number of observations}
  \item{\code{nvars}}{the number of variables} 
  \item{\code{var_indices}}{the indices of the non-constant columns of the
  design matrix}
  \item{\code{interactions}}{a 2-row matrix with columns
  giving the interactions that were added to the design matrix} 
  \item{\code{path_lookup}}{a matrix with columns corresponding to iterations
  and rows to lambda values. Entry \eqn{ij} gives the component of the
  \code{a0} and \code{beta} lists that gives the coefficients for the
  \eqn{i}th \code{lambda} value and \eqn{j}th iteration} 
  \item{\code{l_start}}{a vector with component entries giving the minimimum
  \code{lambda} index in the corresponding copmonents of \code{beta} and
  \code{a0}}
 }
}
\description{
Computes a number of Lasso solution paths with increasing numbers of
interactions present in the design matrices corresponding to each path.
Previous paths are used to speed up computation of subsequent paths so the
process is very fast.
}
\details{
The Lasso optimisations are performed using coordinate descent similarly to
  the \pkg{glmnet} package. An intercept term is always included. Variables
  are centred and scaled to have equal empirical variance. Interactions are
  constructed from these centred and scaled variables, and the interactions
  themselves are also centred and scaled. Note the coefficients are returned
  on the original scale of the variables. Coefficients returned for
  interactions are for simple pointwise products of the original variables
  with no scaling.
}
\examples{
x <- matrix(rnorm(100*250), 100, 250)
y <- x[, 1] + x[, 2] - x[, 1]*x[, 2] + x[, 3] + rnorm(100)
out <- LassoBT(x, y, iter_max=10)
}
\references{
Shah, R. D. (2016) \emph{Shah, R. D. (2016) Modelling interactions in high-dimensional
  data with Backtracking. JMLR, 17, 1-31}
  \url{https://www.jmlr.org/papers/volume17/13-515/13-515.pdf}
}
\seealso{
\code{\link{predict.BT}}, \code{\link{coef.BT}} methods and the \code{\link{cvLassoBT}}
  function.
}
