% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_Catch.R
\name{get_annual_catch}
\alias{get_annual_catch}
\alias{get_annual_catch,missing,missing-method}
\alias{get_annual_catch,LeMans_param,missing-method}
\alias{get_annual_catch,LeMans_param,LeMans_outputs-method}
\alias{get_annual_catch,missing,LeMans_outputs-method}
\alias{get_CPUE}
\alias{get_CPUE,LeMans_param,LeMans_outputs-method}
\alias{get_CPUE,LeMans_param,missing-method}
\alias{get_CPUE,missing,LeMans_outputs-method}
\alias{get_CPUE,missing,missing-method}
\alias{get_CPG}
\alias{get_CPG,LeMans_param,LeMans_outputs-method}
\alias{get_CPG,LeMans_param,missing-method}
\alias{get_CPG,missing,LeMans_outputs-method}
\alias{get_CPG,missing,missing-method}
\title{Get annual catch for each species, catch per unit effort or catch per gear}
\usage{
get_annual_catch(inputs, outputs, ...)

\S4method{get_annual_catch}{missing,missing}(
  Catch,
  years = (dim(Catch)[3] + (inc_first - 1)) * phi_min,
  phi_min = 0.1,
  inc_first = FALSE
)

\S4method{get_annual_catch}{LeMans_param,missing}(
  inputs,
  Catch,
  years = (dim(Catch)[3] + (inc_first - 1)) * inputs@phi_min,
  inc_first = FALSE
)

\S4method{get_annual_catch}{LeMans_param,LeMans_outputs}(
  inputs,
  outputs,
  years = (dim(outputs@Catch)[3] + (inc_first - 1)) * inputs@phi_min,
  inc_first = FALSE
)

\S4method{get_annual_catch}{missing,LeMans_outputs}(
  outputs,
  years = (dim(outputs@Catch)[3] + (inc_first - 1)) * phi_min,
  phi_min = 0.1,
  inc_first = FALSE
)

get_CPUE(inputs, outputs, ...)

\S4method{get_CPUE}{LeMans_param,LeMans_outputs}(inputs, outputs, effort, years = nrow(effort), inc_first = FALSE)

\S4method{get_CPUE}{LeMans_param,missing}(inputs, Catch, effort, years = nrow(effort), inc_first = FALSE)

\S4method{get_CPUE}{missing,LeMans_outputs}(
  outputs,
  Qs,
  effort,
  years = nrow(effort),
  phi_min = 0.1,
  inc_first = FALSE
)

\S4method{get_CPUE}{missing,missing}(
  Catch,
  Qs,
  effort,
  years = nrow(effort),
  phi_min = 0.1,
  inc_first = FALSE
)

get_CPG(inputs, outputs, ...)

\S4method{get_CPG}{LeMans_param,LeMans_outputs}(inputs, outputs, effort, years = nrow(effort), inc_first = FALSE)

\S4method{get_CPG}{LeMans_param,missing}(inputs, Catch, effort, years = nrow(effort), inc_first = FALSE)

\S4method{get_CPG}{missing,LeMans_outputs}(
  outputs,
  Qs,
  effort,
  years = nrow(effort),
  phi_min = 0.1,
  inc_first = FALSE
)

\S4method{get_CPG}{missing,missing}(
  Catch,
  Qs,
  effort,
  years = nrow(effort),
  phi_min = 0.1,
  inc_first = FALSE
)
}
\arguments{
\item{inputs}{A \code{\linkS4class{LeMans_param}} object containing the parameter values of the current LeMans model.}

\item{outputs}{A \code{\linkS4class{LeMans_outputs}} object containing the outputs of the model run.}

\item{...}{Additional arguments.}

\item{Catch}{An array with dimensions \code{nsc}, \code{nfish} and \code{tot_time} representing the number of individuals in each length class for each time step.}

\item{years}{A numeric value representing the number of years included in \code{Catch}.}

\item{phi_min}{A numeric value representing the time step of the model.}

\item{inc_first}{A logical statement indicating whether the first time step of \code{Catch} should be included. The default is \code{FALSE}.}

\item{effort}{A matrix with dimensions \code{years} and the number of fishing gears, representing fishing effort in each year for each gear.}

\item{Qs}{An array of dimensions \code{nsc}, \code{nfish} and \code{gear} representing the catchability of each species by each of the fishing gears.}
}
\value{
\code{get_annual_catch} returns a matrix with dimensions \code{years} and \code{length(species)} where the \code{i,j}th element represents the total catch (g) of the \code{j}th \code{species} in the \code{i}th year.

\code{get_CPUE} returns a matrix with dimensions \code{tot_time} and \code{nfish} where the \code{i,j}th element represents the CPUE in the \code{i}th time step for the \code{j}th species.

\code{get_CPG} returns an array with dimensions \code{nfish}, \code{dim(Qs[3])} and the number of time steps, where the \code{i,j,k}th element denotes the total catch of the \code{i}th species by the \code{j}th gear in the \code{k}th time step.
}
\description{
Get annual catch for each species, the Catch Per Unit Effort (CPUE) or the Catch Per Gear (CPG)
}
\examples{
# Set up and run the model
NS_params <- LeMansParam(NS_par, tau=NS_tau, eta=rep(0.25, 21), L50=NS_par$Lmat, other=1e12)
effort <- matrix(0.5, 10, dim(NS_params@Qs)[3])
model_run <- run_LeMans(NS_params, years=10, effort=effort)

# Get annual catch
get_annual_catch(inputs=NS_params, outputs=model_run)

# Calculate the CPUE
get_CPUE(inputs=NS_params, outputs=model_run, effort=effort)

# Calculate Catch Per Gear (CPG)
get_CPG(inputs=NS_params, outputs=model_run, effort=effort)
}
