% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Draw.R
\name{Draw}
\alias{Draw}
\title{Plots a geometric object}
\usage{
Draw(object, colors = c("black", "black"), label = FALSE)
}
\arguments{
\item{object}{geometric object of any of these five types: point, segment, arc, line or polygon. A point is simply a vector of length 2, which contains the xy-coordinates for the point. For the other four types, there can be created with any of the following functions: \cr 
- \code{CreateArcAngles} \cr 
- \code{CreateArcPointsDist} \cr 
- \code{CreateLineAngle} \cr 
- \code{CreateLinePoints} \cr 
- \code{CreatePolygon} \cr 
- \code{CreateRegularPolygon} \cr 
- \code{CreateSegmentAngle} \cr 
- \code{CreateSegmentPoints} \cr}

\item{colors}{Vector containing information about the color for the object to be plotted. In the case of polygons, the vector should have length 2 to define the background color and the border color (in this order). Moreover, it can be used \code{"transparent"} in the case no background color is needed for the polygon. For the other four types of objects, \code{color} should be a vector of length 1 (or a simple string) to indicate the color for the object. If this parameter is not specified the default color is black (for polygons, it is black for the background and the border)}

\item{label}{Boolean, only used for polygons. When \code{label} = \code{TRUE} and the object is a polygon, the plot displays the numbers that correspond to the order of the points of the polygon. If missing, it works as with \code{label} = \code{FALSE}, so the numbers are not displayed}
}
\value{
None. It produces the plot of a geometric object (point, segment, arc, line or polygon) in the current coordinate plane
}
\description{
\code{Draw} plots geometric objects
}
\examples{
x_min <- -5
x_max <- 5
y_min <- -5
y_max <- 5
CoordinatePlane(x_min, x_max, y_min, y_max)
P1 <- c(0,0)
P2 <- c(1,1)
P3 <- c(2,0) 
Poly <- CreatePolygon(P1, P2, P3)
Draw(Poly, c("blue"))
}
