% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AproxPoisNorm.R
\name{AproxPoisNorm}
\alias{AproxPoisNorm}
\title{Illustration of the Normal approximation to Poisson}
\usage{
AproxPoisNorm(lambda, legend = TRUE, xlab = "", ylab = "Probability",
  main = "Normal approximation to Poisson", col.fill = "grey",
  col.line = "red", lwd = 2)
}
\arguments{
\item{lambda}{mean of the Poisson distribution.}

\item{legend}{logical argument indicating whether to display the legend on the plot or not, default to TRUE.}

\item{xlab}{x-axis label; default to empty.}

\item{ylab}{y-axis label; default to "Probability".}

\item{main}{title; default to "Normal approximation to Poisson".}

\item{col.fill}{colour to fill the bars; default to grey.}

\item{col.line}{colour to draw the line of the Normal density; default to red.}

\item{lwd}{line width for the Normal density, a positive number; default to 2.}
}
\value{
This function is called for the side effect of drawing the plot.
}
\description{
When certain conditions are met (see Details), the Poisson distribution can be approximated by the Normal one. The function \code{AproxPoisNorm} illustrates this fact by plotting the mass diagram corresponding with the discrete distribution (parameter is given by the user) on which the associated Normal density function is also displayed.
}
\details{
The approximation is accurate only if lambda>=10.
}
\examples{
lambda=15
AproxPoisNorm(lambda)
AproxPoisNorm(lambda,col.fill="blue",col.line="orange")
AproxPoisNorm(lambda,legend=FALSE)

}
