% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tStudent.R
\name{plotTS}
\alias{plotTS}
\title{Density Function, Distribution Function and/or
Quantile Function Representations associated with a T-Student Distribution}
\usage{
plotTS(df, type = "b", col = "black")
}
\arguments{
\item{df}{the degrees of freedom of the T-Student distribution.}

\item{type}{a character string giving the type of desired plot. The following values are possible:
"b" (default) for density function, distribution function and quantile function representations together,
"dis" for distribution function representation,
"den" for density function representation and "q" for quantile function representation.}

\item{col}{a single colour associated with the different representations; default to "black".}
}
\value{
This function is called for the side effect of drawing the plot.
}
\description{
\code{plotTS} represents density, distribution and/or quantile functions associated with a T-Student
 distribution with \code{df} degrees of freedom.
}
\examples{
df=10
plotTS(df)
plotTS(df,col="red")
plotTS(df,type="q")
plotTS(df,type="dis")
plotTS(df,type="den")
}
