% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samplequant.R
\name{sample.quantile}
\alias{sample.quantile}
\title{Sample Quantiles}
\usage{
sample.quantile(x, tau)
}
\arguments{
\item{x}{a numeric vector containing the sample.}

\item{tau}{the quantile(s) of interest, that must be a number(s) in (0,1).}
}
\value{
A number or a numeric vector of \code{tau}-quantile(s).

A numerical value or vector corresponding with the requested sample quantiles.
}
\description{
\code{sample.quantile} computes a estimation of different quantiles, given a sample {x}, using order statistics.
}
\details{
A quantile \code{tau} determines the proportion of values in a distribution are above or below a certain limit. For instance, given
\code{tau} a number between 0 and 1, the \code{tau}-quantile splits the sample into tow parts with probabilities \code{tau} and
\code{(1-tau)}, respectively.

One possible way to calculate the quantile \code{tau} would be to ordering the sample
and taking as the quantile the smallest data in the sample (first of the ordered sample)
whose cumulative relative frequency is greater than \code{tau}.
If there is a point in the sample with a cumulative relative frequency equal to \code{tau},
then the sample quantile will be calculated as the mean between that point and the next one of the ordered sample.
}
\examples{
x=rnorm(20)
sample.quantile(x,tau=0.5)
sample.quantile(x,tau=c(0.25,0.5,0.75))
}
