% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lfast.R
\name{lfast}
\alias{lfast}
\title{Synthesise rating-scale data with predefined mean and standard deviation}
\usage{
lfast(n, mean, sd, lowerbound, upperbound, items = 1, precision = 0)
}
\arguments{
\item{n}{(positive, int) number of observations to generate}

\item{mean}{(real) target mean, between upper and lower bounds}

\item{sd}{(positive, real) target standard deviation}

\item{lowerbound}{(int) lower bound (e.g. '1' for a 1-5 rating scale)}

\item{upperbound}{(int) upper bound (e.g. '5' for a 1-5 rating scale)}

\item{items}{(positive, int) number of items in the rating scale.
Default = 1}

\item{precision}{(positive, real) can relax the level of accuracy required.
(e.g. '1' generally generates a vector with moments correct within '0.025',
'2' generally within '0.05') Default = 0}
}
\value{
a vector approximating user-specified conditions.
}
\description{
\code{lfast()} applies a simple Evolutionary Algorithm to
find a vector that best fits the desired moments.

\code{lfast()} generates random discrete values from a
scaled Beta distribution so the data replicate an ordinal rating scale -
for example, a Likert scale made from multiple items (questions) or 0-10
likelihood-of-purchase scale. Data generated are generally consistent with
real data, as shown in the \emph{lfast() validation article}.
}
\examples{

## six-item 1-7 rating scale
x <- lfast(
  n = 256,
  mean = 4.0,
  sd = 1.25,
  lowerbound = 1,
  upperbound = 7,
  items = 6
)

## five-item -3 to +3 rating scale
x <- lfast(
  n = 64,
  mean = 0.025,
  sd = 1.25,
  lowerbound = -3,
  upperbound = 3,
  items = 5
)

## four-item 1-5 rating scale with medium variation
x <- lfast(
  n = 128,
  mean = 3.0,
  sd = 1.00,
  lowerbound = 1,
  upperbound = 5,
  items = 4,
  precision = 5
)

## eleven-point 'likelihood of purchase' scale
x <- lfast(256, 3, 3.0, 0, 10)

}
\seealso{
\itemize{
\item lfast validation article:
\url{https://winzarh.github.io/LikertMakeR/articles/lfast_validation.html}
\item Package website:
\url{https://winzarh.github.io/LikertMakeR/}
}
}
