% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_plots.R
\name{plot_outcome_CONT}
\alias{plot_outcome_CONT}
\title{Function that plots the median (or another quantile) of the posterior function of a continous outcome along with the quanatile-based credible interval.
The function is plotted on top of the binned input data. To bin the data, the score data
is divided into bins of fixed length, then the average outcome in each bin is calculated.
The average outcomes are plotted against the average values of the score in the corresponding bins.}
\usage{
plot_outcome_CONT(
  LoTTA_posterior,
  nbins = 100,
  probs = c(0.025, 0.5, 0.975),
  n_eval = 200,
  col_line = "#E69F00",
  size_line = 0.1,
  alpha_interval = 0.35,
  col_dots = "gray",
  size_dots = 3,
  alpha_dots = 0.6,
  col_cutoff = "black",
  title = "Outcome function",
  subtitle = NULL,
  y_lab = "",
  x_lab = expression(paste(italic("x"), " - score")),
  plot.theme = theme_classic(base_size = 14),
  legend.position = "none",
  name_legend = "Legend",
  labels_legend = "median outcome fun.",
  text = element_text(family = "serif"),
  legend.text = element_text(size = 14),
  plot.title = element_text(hjust = 0.5),
  plot.subtitle = element_text(hjust = 0.5),
  ...
)
}
\arguments{
\item{LoTTA_posterior}{\itemize{
\item output of one of the LoTTA functions (LoTTA_sharp, LoTTA_fuzzy)
}}

\item{nbins}{\itemize{
\item number of bins to aggregate the input data
}}

\item{probs}{\itemize{
\item list of three quantiles, the first and the last one define the quanatile-based credible interval,
the middle value defines the quantile of the posterior function to plot;
by default the quantiles correspond to the median posterior function and 95\% credible interval
probs=c(0.025,0.5,0.975)
}}

\item{n_eval}{\itemize{
\item n_eval*range(x) is the number of points at which each posterior function is evaluated,
the higher number means slower computing time and a smoother plot; default n_eval=200
}}

\item{col_line}{\itemize{
\item the color of the line and the band
}}

\item{size_line}{\itemize{
\item thickness of the line
}}

\item{alpha_interval}{\itemize{
\item alpha value of the band, lower values correspond to a more transparent color
}}

\item{col_dots}{\itemize{
\item color of the dots that correspond to the binned data
}}

\item{size_dots}{\itemize{
\item size of the dots that correspond to the binned data
}}

\item{alpha_dots}{\itemize{
\item transparency of the dots that correspond to the binned data,
lower values correspond to a more transparent color
}}

\item{col_cutoff}{\itemize{
\item color of the dotted line at the cutoff
}}

\item{title}{\itemize{
\item title of the plot
}}

\item{subtitle}{\itemize{
\item subtitle of the plot
}}

\item{y_lab}{\itemize{
\item label of the y-axis
}}

\item{x_lab}{\itemize{
\item label of the x-axis
}}

\item{plot.theme}{\itemize{
\item ggplot2 plot theme (see https://ggplot2.tidyverse.org/reference/ggtheme.html)
possibly with additional arguments, it takes the default value plot.theme=theme_classic(base_size = 14),
}}

\item{legend.position}{\itemize{
\item position of the legend, refer to ggplot2 manual for the possible values;
by default legend is not printed legend.position='none'
}}

\item{name_legend}{\itemize{
\item title of the legend
}}

\item{labels_legend}{\itemize{
\item the label of the plotted function in the legend
}}

\item{text}{\itemize{
\item can be any value that is accepted in the argument \emph{text} in the \emph{theme} function
of ggplot2 package,refer to ggplot2 manual for the possible values;
by default is changes font to a serif one text=element_text(family='serif')
}}

\item{legend.text}{\itemize{
\item can be any value that is accepted in the argument \emph{legend.text} in the \emph{theme} function
of ggplot2 package,refer to ggplot2 manual for the possible values;
by default is changes font size to the legend to 14 legend.text=element_text(size = 14)
}}

\item{plot.title}{\itemize{
\item can be any value that is accepted in the argument \emph{plot.title} in the \emph{theme} function
of ggplot2 package,refer to ggplot2 manual for the possible values;
by default it centers the plot title plot.title = element_text(hjust = 0.5)
}}

\item{plot.subtitle}{\itemize{
\item can be any value that is accepted in the argument \emph{plot.subtitle} in the \emph{theme} function
of ggplot2 package,refer to ggplot2 manual for the possible values;
by default it centers the plot subtitle plot.title = element_text(hjust = 0.5)
}}

\item{...}{\itemize{
\item other arguments of the \emph{theme} function, refer to ggplot2 manual
}}
}
\value{
ggplot2 object
}
\description{
Function that plots the median (or another quantile) of the posterior function of a continous outcome along with the quanatile-based credible interval.
The function is plotted on top of the binned input data. To bin the data, the score data
is divided into bins of fixed length, then the average outcome in each bin is calculated.
The average outcomes are plotted against the average values of the score in the corresponding bins.
}
\keyword{internal}
