% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/further_functions.R
\name{loop_summary}
\alias{loop_summary}
\title{Summary of a loop list}
\usage{
loop_summary(loop_list, column_val = "length")
}
\arguments{
\item{loop_list}{List of loops as dataframe with columns \code{length},
\code{sign}.}

\item{column_val}{String indicating the orientation of the summary table.
By default, rows of the results table are the sign of the loops, columns
are loop lengths. If \code{column_val} is set to \code{"sign"}, columns
and rows are exchanged.}
}
\description{
Summarizes the loops in a loop list by their length and sign, returns an
overview table of the numbers of all, negative and positive loops divided
by their lengths.
}
\details{
Lengths are abbreviated by \code{len_1}, \code{len_2},
\code{len_3} etc., signs are
abbreviated by \code{pos} for positive, \code{neg} for negative loops. The table
contains entries for each loop length from 1 to the maximal loop length
encountered in the table, and zeros are filled in if no loops of a
certain length exist in the table.
}
\examples{
#sample Jacobian matrix of a system with 4 variables
jac_matrix <- rbind(c(-1,0,0,-1),c(1,-1,0,1),c(0,1,-1,0),c(0,0,1,-1))
#find the feedback loops of the system
loop_list <- find_loops(jac_matrix,10)
#loop summary table
loop_sum_tab <- loop_summary(loop_list)

}
