% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal-expected_vars.R
\name{expected_groups}
\alias{expected_groups}
\title{Find expected groups based on distinct values across a set of variables}
\usage{
expected_groups(data, vars)
}
\arguments{
\item{data}{A data frame whose columns you want to examine.}

\item{vars}{Character vector of column names in \code{data} to use.}
}
\value{
A named list with two elements:
\describe{
\item{grid}{A data.frame where each row is one combination of the variable levels
(equivalent to what \code{\link{expand.grid}} would produce).}
\item{levels}{A named list; for each variable in \code{vars} it gives the sorted
unique values (or factor levels) observed in \code{data}.}
}
}
\description{
Given a data frame and a set of discrete (or factor) variables,
returns all combinations of their observed levels \strong{and} the list of levels.
}
\keyword{internal}
