% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numeric_basis_expansion.R
\name{numeric_basis_expansion}
\alias{numeric_basis_expansion}
\alias{numeric_basis_expansion,functional_variable,numeric_basis-method}
\title{Numeric basis expansion for functional variable data}
\usage{
numeric_basis_expansion(object, num_basis)

\S4method{numeric_basis_expansion}{functional_variable,numeric_basis}(object, num_basis)
}
\arguments{
\item{object}{a \code{\link{functional_variable}} class object.
The minimum and maximum of the slot \code{t_points} should be respectively
equal to the slot \code{t_0} and slot \code{t_0} plus slot \code{period}.}

\item{num_basis}{a \code{numeric_basis} class object, representing the function basis.
See \code{\link{numeric_basis}}.}
}
\value{
Returns a numeric matrix, \eqn{(b_{ik})_{n\times p}},
with an extra attribute \code{numeric_basis}, which is the \code{numeric_basis} object input
by the argument \code{num_basis}.
}
\description{
For a function \eqn{f(t), t\in\Omega}, and a basis function sequence \eqn{\{\rho_k\}_{k\in\kappa}},
basis expansion is to compute \eqn{\int_\Omega f(t)\rho_k(t) dt}.
Here we do basis expansion for all \eqn{f_i(t), t\in\Omega = [t_0,t_0+T]} in functional variable data, \eqn{i=1,\dots,n}.
We compute a matrix \eqn{(b_{ik})_{n\times p}}, where \eqn{b_{ik} = \int_\Omega f(t)\rho_k(t) dt}.
The basis we use here is numerically represented by the value of basis functions
at some points in the domain.
}
\author{
Heyang Ji
}
