% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/invariant.R
\name{invariant}
\alias{invariant}
\title{Account for invariance of configurations.}
\usage{
invariant(z, zMAP)
}
\arguments{
\item{z}{An n x d matrix of latent locations in the d dimensional space for each of n nodes.}

\item{zMAP}{The \emph{maximum a posteriori} configuration of latent locations used as the template to which all sampled configurations are mapped.}
}
\value{
The transformed version of the input configuration z that best matches zMAP.
}
\description{
This function accounts for the fact that configurations in the latent space are invariant to rotations, reflections and translations.
}
\details{
Procrustean rotations, reflections and translations (note: NOT dilations) are employed to best match z to zMAP.
}
\references{
Isobel Claire Gormley and Thomas Brendan Murphy. (2010) A Mixture of Experts Latent Position Cluster Model for Social Network Data. Statistical Methodology, 7 (3), pp.385-405.
}
\seealso{
\code{\link{MEclustnet}}
}
