% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_data.R
\name{import_enmo_csv}
\alias{import_enmo_csv}
\title{Import ENMO data stored in csv csv}
\usage{
import_enmo_csv(filepath, enmo_col = 2)
}
\arguments{
\item{filepath}{string. The filepath of the input data.}

\item{enmo_col}{number. The index of column of ENMO values in the csv file.}
}
\value{
dataframe. The imported ENMO data, with the first column being the
  timestamps in POSIXct format, and the second column being the ENMO values.
  Column names: \code{HEADER_TIME_STAMP}, \code{ENMO}.
}
\description{
\code{import_enmo_csv} imports ENMO data stored in a summary csv format,
which was exported by the
\href{https://github.com/OxWearables/biobankAccelerometerAnalysis}{biobank
data analysis tools}.
}
\section{How is it used in MIMS-unit algorithm?}{
 This function is a File IO
  function that is used to import ENMO data from activity monitor devices
  during algorithm validation.
}

\examples{
  # Use the enmo csv file shipped with the package
  filepath = system.file('extdata', 'enmo.csv', package='MIMSunit')

  # Check original data format
  readLines(filepath)[1:5]

  # Load file, default column for enmo values are 2
  output = import_enmo_csv(filepath, enmo_col=2)

  # Check output
  head(output)
}
\seealso{
Other File I/O functions: 
\code{\link{export_to_actilife}()},
\code{\link{import_actigraph_count_csv}()},
\code{\link{import_actigraph_csv_chunked}()},
\code{\link{import_actigraph_csv}()},
\code{\link{import_actigraph_meta}()},
\code{\link{import_activpal3_csv}()},
\code{\link{import_mhealth_csv_chunked}()},
\code{\link{import_mhealth_csv}()}
}
\concept{File I/O functions}
