% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simMultiJM.R
\name{simMultiJM}
\alias{simMultiJM}
\title{New Simulation Function For Multivariate JMs Based On FPCs}
\usage{
simMultiJM(
  nsub = 300,
  times = seq(0, 120, 1),
  probmiss = 0.75,
  max_obs = length(times),
  maxfac = 1.5,
  nmark = 2,
  long_assoc = c("FPC", "splines", "param"),
  M = 6,
  FPC_bases = NULL,
  FPC_evals = NULL,
  mfpc_args = list(type = "split", eFunType = "Poly", ignoreDeg = NULL, eValType =
    "linear", eValScale = 1),
  re_cov_mat = NULL,
  ncovar = 2,
  lambda = function(t, x) {
     1.4 * log((t + 10)/1000)
 },
  gamma = function(x) {
     -1.5 + 0.3 * x[, 1]
 },
  alpha = rep(list(function(t, x) {
     0.3 + 0 * t
 }), nmark),
  mu = rep(list(function(t, x) {
     1.25 + 0.6 * sin(x[, 2]) + (-0.01) * t
 }), nmark),
  sigma = function(t, x) {
     0.3 + 0 * t + I(x$marker == "m2") * 0.2
 },
  tmax = NULL,
  seed = NULL,
  full = FALSE,
  file = NULL
)
}
\arguments{
\item{nsub}{Number of subjects.}

\item{times}{Vector of time points.}

\item{probmiss}{Probability of missingness.}

\item{max_obs}{Maximal number of observations per individual and marker.
Defaults to no upper limit.}

\item{maxfac}{Factor changing the uniform censoring interval.}

\item{nmark}{Number of markers.}

\item{long_assoc}{Longitudinal association between the markers (Defaults to
"FPC"). If "splines" or "param", then specify the normal covariance matrix
with argument 're_cov_mat' and include the random effects in argument mu.
 If "FPC", then principal components are used to model the association
 structure.}

\item{M}{Number of principal components.}

\item{FPC_bases}{FunData object. If supplied, use the contained FPC as basis
for the association structure.}

\item{FPC_evals}{Vector of eigenvalues. If supplied, use the provided
eigenvalues for the association structure.}

\item{mfpc_args}{List containing the named arguments "type", "eFunType",
"ignoreDeg", "eValType" of function simMultiFunData and "eValScale" for
scaling the eigenvalues.}

\item{re_cov_mat}{If supplied, a covariance matrix to use for drawing the
random effects needed for the association structure.}

\item{ncovar}{Number of covariates.}

\item{lambda}{Additive predictor of time-varying survival covariates.}

\item{gamma}{Additive predictor of time-constant survival covariates.}

\item{alpha}{List of length nmark containing the additive predictors of the
association.}

\item{mu}{List of length nmark containing the additive predictors of the
longitudinal part.}

\item{sigma}{Additive predictor of the variance.}

\item{tmax}{Maximal time point of observations.}

\item{seed}{Seed for reproducibility.}

\item{full}{Create a wide-format data.frame and a short one containing only
survival info.}

\item{file}{Name of the data file the generated data set should be stored
into (e.g., "simdata.RData") or NULL if the dataset should directly be
returned in R.}
}
\value{
For \code{full = TRUE} a list of four \code{data.frames} is returned:
   \describe{
   \item{data}{Simulated dataset in long format including all longitudinal
     and survival covariates.}
   \item{data_full}{Simulated dataset on a grid of fixed time points.}
   \item{data_hypo}{Simulated dataset on a grid of fixed time points with
     hypothetical longitudinal outcomes after the event.}
   \item{fpc_base}{If applicable, include the FPC basis used for simulation.}
   \item{data_short}{Convenience output containing only one observation per
     subject for easy access to event-times.}
}
For \code{full = FALSE} only the first dataset is returned.
}
\description{
Adapt the structure given by simJM function in bamlss.
}
\examples{
# Number of individuals
n <- 15
# Covariance matrix for the data generation
auto <- matrix(c(0.08, -0.07, -0.07, 0.9), ncol = 2)
cross <- matrix(rep(0.03, 4), ncol = 2)
cor <- matrix(c(0, 1, 0.75, 0.5, 0, 0,
                1, 0, 1, 0.75, 0.5, 0,
                0.75, 1, 0, 1, 0.75, 0.5,
                0.5, 0.75, 1, 0, 1, 0.75,
                0, 0.5, 0.75, 1, 0, 1,
                0, 0, 0.5, 0.75, 1, 0),
              ncol = 6)
cov <- kronecker(cor, cross) +
    kronecker(diag(c(1, 1.2, 1.4, 1.6, 1.8, 2)), auto)

# Simulate the data
d_rirs <- simMultiJM(
  nsub = n, times = seq(0, 1, by = 0.01), max_obs = 15, probmiss = 0.75,
  maxfac = 1.75, nmark = 6, long_assoc = "param", M = NULL, FPC_bases = NULL,
  FPC_evals = NULL, mfpc_args = NULL, re_cov_mat = cov, ncovar = 2,
  lambda = function(t, x) {1.37 * t^(0.37)},
  gamma = function(x) {-1.5 + 0.48*x[, 3]},
  alpha = list(function(t, x) {1.5 + 0*t}, function(t, x) {0.6 + 0*t},
               function(t, x) {0.3 + 0*t}, function(t, x) {-0.3 + 0*t},
               function(t, x) {-0.6 + 0*t}, function(t, x) {-1.5 + 0*t}),
  mu = list(function(t, x, r){
    0 + 0.2*t - 0.25*x[, 3] - 0.05*t*x[, 3] + r[, 1] + r[, 2]*t
  }, function(t, x, r){
    0 + 0.2*t - 0.25*x[, 3] - 0.05*t*x[, 3] + r[, 3] + r[, 4]*t
  }, function(t, x, r){
    0 + 0.2*t - 0.25*x[, 3] - 0.05*t*x[, 3] + r[, 5] + r[, 6]*t
  }, function(t, x, r){
    0 + 0.2*t - 0.25*x[, 3] - 0.05*t*x[, 3] + r[, 7] + r[, 8]*t
  }, function(t, x, r){
    0 + 0.2*t - 0.25*x[, 3] - 0.05*t*x[, 3] + r[, 9] + r[, 10]*t
  }, function(t, x, r){
    0 + 0.2*t - 0.25*x[, 3] - 0.05*t*x[, 3] + r[, 11] + r[, 12]*t
  }),
  sigma = function(t, x) {log(0.06) + 0*t}, tmax = NULL, seed = NULL,
  full = TRUE, file = NULL)
}
