% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MMLR.R
\name{Aver_soj_time}
\alias{Aver_soj_time}
\title{Calculating the average sojourn time in each state}
\usage{
Aver_soj_time(ii, tau_observed, Q)
}
\arguments{
\item{ii}{number (scalar)}

\item{tau_observed}{number (scalar), observed time}

\item{Q}{Matrix (m x m), m - number of states}
}
\value{
Vector of average sojourn times in each state.
Vector components in total should give observation time (tau_observed).
}
\description{
Calculating expectation of sojourn times in states for the observed time and for given initial state, using eigenvalues and eigenvectors.
}
\details{
Calculating expectation of sojourn times in states for the observed time (tau_observed) and if initial state is given (ii).
Matrix Q is so-called Generator matrix:  \eqn{Q=\lambda-\Lambda, where \lambda} is matrix with known transition rates from state $s_{i}$ to state $s_{j}$,
and \eqn{\Lambda} is diagonal matrix with a vector  \eqn{(\Lambda_{1},...,\Lambda_{m}} on the main diagonal, where m is a number of states of external environment.
Eigenvalues and eigenvectors are used in calculations.
}
\examples{
lambda <- matrix(c(0, 0.33, 0.45, 0), nrow = 2, ncol = 2, byrow = TRUE)
m <- nrow(lambda)
ld <- as.matrix(rowSums(lambda))
Lambda <- diag(as.vector(ld))
Generator <- t(lambda) - Lambda
Aver_soj_time(1,10,Generator)
}
