% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernelLaplacian.R
\name{kernelLaplacian}
\alias{kernelLaplacian}
\title{Calculate the graph Laplacian of a given data set}
\usage{
kernelLaplacian(
  dat,
  kernel = c("Gaussian", "ZM", "Spectrum", "Linear"),
  laplacian = c("shift", "Ng", "sym", "rw"),
  grf.type = c("full", "knn", "e-graph"),
  k = 5,
  p = 5,
  rho = NULL,
  epsilon = 0,
  mutual = FALSE,
  binary.grf = FALSE,
  plots = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{dat}{A matrix like object with subjects as rows and features as columns.}

\item{kernel}{The type of kernel used to calculate the graph's adjacency matrix: \code{"Gaussian"} for the standard Gaussian kernel, \code{"ZM"} for the Zelnik-Manor kernel, \code{"Spectrum"} for the spectrum kernel, \code{"Linear"} for the linear kernel (dot product), and \code{"Cor"} for a kernel of pairwise correlations. See references for more details.}

\item{laplacian}{One of \code{"shift"}, \code{"Ng"}, \code{"rw"} or \code{"sym"}. See details for description}

\item{grf.type}{Type of graph to calculate: \code{"full"} for adjacency matrix equal to the kernel, \code{"knn"} for a k-nearest neighbors graph, \code{"e-graph"} for an "epsilon graph"}

\item{k}{An integer value for \code{k} in the k-nearest neighbors graph. Only the \code{k} largest edges (most similar neighbors) will be kept}

\item{p}{An integer value for the p-nearest neighbor in the \code{ZM} kernel}

\item{rho}{A value for the dispersion parameter in the Gaussian kernel. It is in the denominator of the exponent, so higher values correspond to lower similarity. By default it is the median pairwise Gaussian distance}

\item{epsilon}{The cutoff value for the \code{e-graph}. Edges lower than this value will be removed}

\item{mutual}{Make a "mutual" knn graph. Only keeps edges when two nodes are both in each others k-nearest set}

\item{binary.grf}{Set all edges >0 to 1}

\item{plots}{Whether or not to plot the final graph, a heatmap of calculated kernel, and the eigen values of the Laplacian}

\item{verbose}{Whether or not to give some summary statistics of the pairwise distances}
}
\value{
An n\eqn{\times}n matrix where \code{n} is the number of rows in \code{dat}.
}
\description{
Calculate the graph laplacian from a given data set with subjects as rows and features as columns.
}
\details{
The four Lapalacians are defined as \eqn{L_{shift}=I+D^{-1/2}AD^{-1/2}}, \eqn{L_{Ng}=D^{-1/2}AD^{-1/2}}, \eqn{L_{sym}=I-D^{-1/2}AD^{-1/2}}, and \eqn{L_{rw}=I-D^{-1}A}. The shifted Laplacian, \eqn{L_{shift}=I+D^{-1/2}AD^{-1/2}}, is recommended for multi-view spectral clustering.
}
\examples{

## Generating data with 3 distinct clusters
## Note that 'clustStruct' returns a list
dd <- clustStruct(n=120, p=30, k=3, noiseDat='random')[[1]]

kernelLaplacian(dd, kernel="Spectrum")
}
\references{
\url{https://academic.oup.com/bioinformatics/article/36/4/1159/5566508#199177546}
}
