% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/se_auc_sample_size.R
\name{sampleSize_Standalone}
\alias{sampleSize_Standalone}
\title{Estimate sample sizes for standalone studies with sensitivity or AUC as endpoint}
\usage{
sampleSize_Standalone(
  endpoint = "auc",
  theta,
  precision,
  R = 1,
  power = 0.8,
  alpha = 0.05,
  var_auc = "obuchowski",
  corr = FALSE,
  ICC = NULL,
  s = NULL
)
}
\arguments{
\item{endpoint}{Character string to inform what is the endpoint (Figure-Of-Merit - FOM) of the standalone study. Values can be either \code{auc} or \code{sensitivity}.}

\item{theta}{Expected average value of the FOM Must be a value between 0 and 1.}

\item{precision}{Required precision of the point estimate of FOM. This is equivalent to half-width of the confidence interval. Must be a numeric value between 0 and 1.}

\item{R}{Ratio of non-diseased cases to diseased cases. Defaults to 1.}

\item{power}{Power to detect \code{delta} given all other assumptions. Default value is 0.8 corresponding to 80 percent power.}

\item{alpha}{The type I error rate. Default value is 0.05 corresponding to 5 percent type I error (significance level).}

\item{var_auc}{Variance estimation method when endpoint is \code{auc}. Defaults to the string \code{obuchowski}. If value is changed to \code{blume}, then method proposed by Blume (2009) will be used to estimate the variance.}

\item{corr}{Logical value indicating if \code{ICC (intra-cluster correlation)} has to be adjusted (\code{TRUE}) or not (\code{FALSE}). Defaults to \code{FALSE}.}

\item{ICC}{A numerical value between 0 and 1 indicating the expected ICC if \code{corr} is \code{TRUE}.}

\item{s}{Average number of lesions in diseased cases. This must be a numeric value greater than or equal to 1.}
}
\value{
A named list
\itemize{
  \item \code{SampleSizeResults} - A list containing the sample size results.
}
}
\description{
\code{sampleSize_MRMC} This function returns number of cases required for a standalone study for endpoints of sensitivity and AUC.
}
\details{
When \code{corr = FALSE}, the \code{nUnits_i} in \code{SampleSizeResults} is the number of diseased cases. The number of total cases (\code{nTotal}) required will depend on the
the ratio \code{R} specified.
When \code{corr = TRUE}, the anticipated correlation between units within the same diseased cases are adjusted and the \code{nUnits_i} in \code{SampleSizeResults}
list is the number of units in diseased cases assuming independence. The number of diseased cases required in this scenario will be given
by \code{nCases_c}. Again, \code{nTotal} will depend on the \code{R} specified.
}
\examples{
library("MRMCsamplesize")
result1 <- sampleSize_Standalone(endpoint = "auc", theta = 0.9, precision = 0.05,
                                 R = 1, corr = TRUE, ICC = 0.5, s = 1.25)
result2 <- sampleSize_Standalone(endpoint = "Se", theta = 0.8, precision = 0.05, R = 1)
}
\references{
\itemize{
\item Flahault A, Cadilhac M, Thomas G. Sample size calculation should be performed for design accuracy in diagnostic test studies. J Clin Epidemiol. 2005 Aug;58(8):859-62. doi: 10.1016/j.jclinepi.2004.12.009. PMID: 16018921.
\item Zhou, X.-H., Obuchowski, N.A. and McClish, D.K. (2011). Sample Size Calculations. In Statistical Methods in Diagnostic Medicine (eds X.-H. Zhou, N.A. Obuchowski and D.K. McClish). https://doi.org/10.1002/9780470906514.ch6
}
}
\author{
Dennis Robert \email{dennis.robert.nm@gmail.com}
}
