% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tb.R
\name{forecasting.Tb}
\alias{forecasting.Tb}
\title{Forecasting method for the Tb method}
\usage{
\method{forecasting}{Tb}(model, newdata, includes_transformed_newdata = FALSE)
}
\arguments{
\item{model}{Object of class "Tb" generated by \code{\link{Tb}} or
\code{\link{generates_model}}(..., method = "Tb").}

\item{newdata}{Matrix with n rows (samples) and p columns (variables). The
Data to be estimated. All data should be continuous values
and should not have missing values.}

\item{includes_transformed_newdata}{If \code{TRUE}, then the transformed data
for \code{newdata} are included in a
return object.}
}
\value{
A list containing the following components is returned.

 \item{M_hat}{Vector with length n. The estimated values of the dependent
               variable after the data transformation.}
 \item{y_hat}{Vector with length n. The estimated values after the inverse
               transformation from \code{M_hat}.}
 \item{model}{Object of class "Tb" passed by \code{model}.}
 \item{n}{The number of samples for \code{newdata}.}
 \item{q}{The number of variables after the data transformation. q equals p.}
 \item{X}{If \code{includes_transformed_newdata} is \code{TRUE}, then the
           transformed data for \code{newdata} are included.}
}
\description{
\code{forecasting.Tb} (via \code{\link{forecasting}}) estimates the dependent
  values based on the Tb model.
}
\examples{
model_Tb <- Tb(sample_data = stackloss[-c(2, 12, 19), ],
               subtracts_V_e = TRUE,
               includes_transformed_data = TRUE)

forecasting_Tb <- forecasting(model = model_Tb,
                              newdata = stackloss[c(2, 12, 19), -4],
                              includes_transformed_newdata = TRUE)

(forecasting_Tb$y_hat) # Estimated values
(stackloss[c(2, 12, 19), 4]) # True values

}
\references{
Inou, A., Nagata, Y., Horita, K., & Mori, A. (2012). Prediciton Accuracies
    of Improved Taguchi's T Methods Compared to those of Multiple Regresssion
    Analysis. \emph{Journal of the Japanese Society for Quality Control,
    42}(2), 103-115. (In Japanese)

  Kawada, H., & Nagata, Y. (2015). An application of a generalized inverse
    regression estimator to Taguchi's T-Method. \emph{Total Quality Science,
    1}(1), 12-21.
}
\seealso{
\code{\link{general_forecasting.T}} and \code{\link{Tb}}
}

