% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getVIRank.R
\name{getVIRank}
\alias{getVIRank}
\title{Get variable importance}
\usage{
getVIRank(MUVRclassObject, model = "mid", n, all = FALSE)
}
\arguments{
\item{MUVRclassObject}{an object of MUVR class}

\item{model}{which model to use ("min", "mid" (default), or "max")}

\item{n}{customize values}

\item{all}{logical, to get the ranks of all variable or not}
}
\value{
data frame with order, name and average rank of variables (`order`, `name` & `rank`)
}
\description{
Extract autoselected variables from MUVR model object.
}
\examples{
\donttest{
data("freelive2")
nRep <- 2
nOuter <- 4
varRatio <-0.6
regrModel <- MUVR2(X = XRVIP2,
                   Y = YR2,
                   nRep = nRep,
                   nOuter = nOuter,
                   varRatio = varRatio,
                   method = "PLS",
                   modReturn = TRUE)
getVIRank(regrModel, model="min")
}
}
