% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getVar.R
\name{getVar}
\alias{getVar}
\title{Get min, mid or max model from Elastic Net modelling}
\usage{
getVar(
  rdCVnetObject,
  option = c("quantile", "fitness"),
  fit_curve = c("loess", "gam"),
  span = 1,
  k = 5,
  outlier = c("none", "IQR", "residual"),
  robust = 0.05,
  quantile = 0.25
)
}
\arguments{
\item{rdCVnetObject}{an object obtained from the rdCVnet() function}

\item{option}{quantile or fitness: which way to perform variable selection}

\item{fit_curve}{gam or loess method for fitting the curve in the fitness option}

\item{span}{parameter for using loess to fit curve in the fitness option:  how smooth the curve needs to be}

\item{k}{parameter for using gam to fit curve in the fitness option}

\item{outlier}{if remove outlier variables or not. There are 3 options: "none","IRQ", "residual"}

\item{robust}{if the option is fitness, robust parameter decides how much deviation it is allowed from the optimal perdiction performance for min and max variabel selection}

\item{quantile}{if the option is quantile, this value decides the cut for the first quantile, ranging from 0 to 0.5}
}
\value{
a rdCVnet object
}
\description{
Obtain the min, mid, or max number of variables for an object generated from the rdCVnet() function.
}
\examples{
\donttest{
data("mosquito")
nRep <- 2
nOuter <- 4
varRatio <-0.6
classModel <- MUVR2_EN(X = Xotu,
                       Y = Yotu,
                       nRep = nRep,
                       nOuter = nOuter,
                       DA = TRUE,
                       modReturn = TRUE)
classModel<-getVar(classModel)
}
}
