% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qMUVR2.R
\name{qMUVR2}
\alias{qMUVR2}
\title{Wrapper for speedy access to MUVR2 (autosetup of parallelization)}
\usage{
qMUVR2(
  X,
  Y,
  ML = FALSE,
  method = "RF",
  varRatio = 0.65,
  nCore,
  repMult = 1,
  nOuter = 5,
  ...
)
}
\arguments{
\item{X}{X-data}

\item{Y}{Y-data}

\item{ML}{Boolean for multilevel}

\item{method}{'RF' (default) or 'PLS'}

\item{varRatio}{proportion of variables to keep in each loop of the recursive feature elimination}

\item{nCore}{Number of threads to use for calculation (defaults to detectCores()-1)}

\item{repMult}{Multiplier of cores -> nRep = repMult * nCore}

\item{nOuter}{Number of outer segments}

\item{...}{Additional arguments(see MUVR)}
}
\value{
MUVR object
}
\description{
Wrapper for speedy access to MUVR2 (autosetup of parallelization)
}
\examples{
\donttest{
data("freelive2")
regrModel <- qMUVR2(X = XRVIP2,
                    Y = YR2,
                    nCore = 1)
}
}
