% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Plotstand.R, R/plottree.R
\name{Plotstand}
\alias{Plotstand}
\alias{plottree}
\title{Plot the stand in 3D}
\usage{
Plotstand(treesfile = "trees.dat", strfile = "str.dat",
  crownshape = c("cone", "ellipsoid", "round", "halfellipsoid", "paraboloid",
  "cylinder"), readstrfiles = TRUE, targethighlight = TRUE,
  addNarrow = TRUE, xyaxes = TRUE, labcex = 1, axiscex = 1,
  verbose = FALSE, idate = 1, path = "", ...)

plottree(crownshape = c("cone", "elipsoid", "ellipsoid", "round",
  "halfellipsoid", "paraboloid", "cylinder"), CL = 1, CW = 1, HCB = 1,
  X = 0, Y = 0, dbh = 0.3, crowncolor = "forestgreen",
  stemcolor = "brown", nz = 25, nalpha = 25, ...)
}
\arguments{
\item{treesfile}{By default, the 'trees.dat' file in the current dir.}

\item{strfile}{Not used, yet.}

\item{crownshape}{Character,
"cone","elipsoid","ellipsoid","halfellipsoid","paraboloid","cylinder", or
abbreviation.}

\item{readstrfiles}{Read the 'str.dat' file(s) to find out crown shape?}

\item{targethighlight}{Plot the target trees in red?}

\item{addNarrow}{Logical. Add arrow pointing North?}

\item{xyaxes}{Logical. Add annotated X and Y axes?}

\item{labcex}{Relative size of X and Y axis labels.}

\item{axiscex}{Relative size of X and Y axis annotation.}

\item{verbose}{If TRUE, writes more info to the screen while plotting.}

\item{idate}{If multiple dates are provided for tree size variables, which
one to display.}

\item{path}{The folder where the input files are stored.}

\item{CL}{Crown length (m).}

\item{CW}{Crown width (m).}

\item{HCB}{Height of crown base (m).}

\item{X,Y}{X- and Y-coordinates of tree stem base (m).}

\item{dbh}{Stem diameter (m). Converted to m if appears to be in cm.}

\item{crowncolor}{The color of the tree crowns. Default, obviously,
'forestgreen'.}

\item{stemcolor}{The color of the tree stems. Default 'brown'.}

\item{nz}{Number of z divisions (increase number to get smoother crowns).}

\item{nalpha}{Number of angular divisions (increase number to get smoother
crowns).}

\item{\dots}{Further parameters passed (to plottree, or triangles3d).}
}
\value{
An rgl device is opened.
}
\description{
Reads the MAESTRA trees file, and plots the stand in 3D. Supports all
MAESTRA crown shapes except the box shape.  Looks for the 'trees.dat' file
in the current working directory, unless specified (see Examples).  The XY
coordinates *must be present* in the 'trees.dat' file. Users will typically
only use the 'Plotstand' function.

Optionally reads the crown shape from the 'str.dat' file, and plots the
correct crown shape for each species in the stand by reading the
multi-species namelists in 'confile.dat' and 'trees.dat'.

The target trees are colored red (unless specified otherwise, see Details),
if the 'itargets' is specified in the confile.

Attempts to read indivradx, indivrady, indivhtcrown, indivdiam, and
indivhttrunk namelists from the 'trees.dat' file. If any of these fail, the
'all' versions are tried ('allradx', etc.).  Although MAESTRA runs fine when
no XY coordinates are provided, this plot function crashes. A future
implementation will calculate XY coordinates in the same way as MAESTRA.

If the 'strfiles' parameter is set in 'confile.dat' (one str.dat file for
each species in the stand), these files are opened and used to set the crown
shape by species. Alternatively, you may specify crownshape as a parameter,
and override reading of str.dat by setting readstrfiles=FALSE.

The 'nz' and 'nalpha' arguments specify the 'smoothness' of the crowns:
higher values provide more detailed triangulation of the crowns, at the
expense of speed.
}
\details{
For large stands, the plot takes quite a while to complete. This code is far
from optimized for speed, because I am patient. Also, minimize the rgl window to greatly speed it up.
}
\examples{
\dontrun{

# Plot the 'trees.dat' file in the current working directory:
Plotstand()

# Open a dialog box to select a trees.dat file:
Plotstand(file.choose())

# Save a snapshot to a .png file.
# Note: make sure to move the 3D plot into view
# (so that other windows are not blocking it!)
snapshot3d('myforest.png')

# For publication-quality graphs:
Plotstand(nz=50, nalpha=50)


}
}
\author{
Remko Duursma
}

