% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mandalar_basic.R
\name{mandalar_basic}
\alias{mandalar_basic}
\title{Create a mandala with algorithm basic}
\usage{
mandalar_basic(curve, theta, k, n, raio, a, b)
}
\arguments{
\item{curve}{Either a character string or a function returning curve equation evaluated at its first argument.
Curves "circle","elipse", "cardioide","limacon", "espiral1", "espiral2", "lemniscata", "deltoide" and "astroide" are recognised, case being ignored.}

\item{theta}{is a vector length 2 with start angle and end angle}

\item{k}{is a angle of rotations, k in (0,360) graus}

\item{n}{is a number of points}

\item{raio}{is a positive number for the radius of circle}

\item{a}{is one of the parameters of the curves; for the ellipse is the radius on the x axis}

\item{b}{is one of the parameters of the curves; for the ellipse is the radius on the y axis}
}
\value{
Returns a dataframe with the original points plus the respective rotations of these points.
}
\description{
Function to create a mandala with the basic method
}
\examples{
require(ggplot2)
mandalar_basic("circle", theta = c(0,2*pi), raio=1, k = 45, n=500)
mandalar_basic("cardioide", theta = c(0,2*pi), raio=1, k = 60, n=500)
mandalar_basic("elipse", theta = c(0,2*pi), a=1, b=2, k = 30, n=500)
}
\author{
Luciane Ferreira Alcoforado
}
