% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{MVmr_cML_DP}
\alias{MVmr_cML_DP}
\title{MVMRcML method with Data Perturbation}
\usage{
MVmr_cML_DP(
  b_exp,
  b_out,
  se_bx,
  Sig_inv_l,
  n,
  K_vec = as.numeric(c()),
  random_start = 1L,
  num_pert = 100L,
  min_theta_range = -0.5,
  max_theta_range = 0.5,
  maxit = 100L,
  thres = 1e-04
)
}
\arguments{
\item{b_exp}{A m*L matrix of SNP effects on the exposure variable.}

\item{b_out}{A m*1 matrix of SNP effects on the outcome variable.}

\item{se_bx}{A m*L matrix of standard errors of \code{b_exp}.}

\item{Sig_inv_l}{A list of the inverse of m covariance matrices.}

\item{n}{The smallest sample size of the L+1 GWAS dataset.}

\item{K_vec}{Sets of candidate K's, the constraint parameter representing number of invalid IVs.}

\item{random_start}{Number of random start points, default is 1.}

\item{num_pert}{Number of perturbation, default is 100.}

\item{min_theta_range}{The lower bound of the uniform distribution for each initial value for theta generated from.}

\item{max_theta_range}{The upper bound of the uniform distribution for each initial value for theta generated from.}

\item{maxit}{Maximum number of iterations for each optimization, default is 100.}

\item{thres}{Threshold for convergence criterion.}
}
\value{
A list
\describe{
\item{BIC_theta}{Estimated causal effect from MVMR-cML-BIC}
\item{BIC_invalid}{Invalid IVs selected by MVMR-cML-BIC}
\item{BIC_DP_theta}{Estimated causal effect from MVMR-cML-DP }
\item{BIC_DP_se}{Estimate standard error for \code{BIC_DP_theta}}
\item{eff_DP_B}{Data perturbation with successful convergence}
\item{DP_ninvalid}{A vector of the number of selected invalid IVs by MVMRcML-BIC in each data perturbation.}
}
}
\description{
This is the internal MVMRcML-DP function of mr_mvcML.
}
