% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/mr_mvivwme-methods.R
\docType{methods}
\name{mr_mvivwme}
\alias{mr_mvivwme}
\alias{mr_mvivwme,MRMVInput-method}
\title{Multivariable inverse-variance weighted method with measurement error}
\usage{
mr_mvivwme(
  object,
  model = "default",
  correl = FALSE,
  correl.x = NULL,
  distribution = "normal",
  alpha = 0.05,
  max_iter = 100,
  no_ini = 1,
  seed = 20201201,
  ...
)

\S4method{mr_mvivwme}{MRMVInput}(
  object,
  model = "default",
  correl = FALSE,
  correl.x = NULL,
  distribution = "normal",
  alpha = 0.05,
  max_iter = 100,
  no_ini = 1,
  seed = 20201201,
  ...
)
}
\arguments{
\item{object}{An \code{MRMVInput} object.}

\item{model}{What type of model should be used: \code{"default"}, \code{"random"} or \code{"fixed"}. The random-effects model (\code{"random"}) is a multiplicative random-effects model, allowing overdispersion in the weighted linear regression (the residual standard error is not fixed to be 1, but is not allowed to take values below 1). The fixed-effect model (\code{"fixed"}) sets the residual standard error to be 1. The \code{"default"} setting is to use a fixed-effect model with 3 genetic variants or fewer, and otherwise to use a random-effects model.}

\item{correl}{If the genetic variants are correlated, then this correlation can be accounted for.}

\item{correl.x}{Correlation matrix for exposures. Default is to assume the exposures are uncorrelated.}

\item{distribution}{The type of distribution used to calculate the confidence intervals. Options are \code{"normal"} (default) or \code{"t-dist"}.}

\item{alpha}{The significance level used to calculate the confidence interval. The default value is 0.05.}

\item{max_iter}{The maximum number of iterations in the optimisation procedure.}

\item{no_ini}{The number of initial values for the optimisation procedure.}

\item{seed}{The random seed to use for the optimisation procedure. The default value is 20201201. If set to \code{NA}, the random seed will not be set (for example, if the function is used as part of a larger simulation).}

\item{...}{Additional arguments to be passed to the regression method.}
}
\value{
The output from the function is an \code{MVIVWME} object containing:

 \item{Model}{A character string giving the type of model used (\code{"fixed"}, \code{"random"}, or \code{"default"}).}
 \item{Exposure}{A character vector with the names given to the exposure.}
 \item{Outcome}{A character string with the names given to the outcome.}
 \item{Estimate}{A vector of causal estimates.}
 \item{StdError}{A vector of standard errors of the causal estimates.}
 \item{CILower}{The lower bounds of the causal estimates based on the estimated standard errors and the significance level provided.}
 \item{CIUpper}{The upper bounds of the causal estimates based on the estimated standard errors and the significance level provided.}
 \item{Alpha}{The significance level used when calculating the confidence intervals.}
 \item{Pvalue}{The p-values associated with the estimates (calculated as Estimate/StdError as per Wald test) using a normal or t-distribution (as specified in \code{distribution}).}
 \item{Correlation}{The matrix of genetic correlations.}
 \item{SNPs}{The number of genetic variants (SNPs) included in the analysis.}
 \item{RSE}{The estimated residual standard error from the regression model.}
 \item{Heter.Stat}{Heterogeneity statistic (Cochran's Q statistic) and associated p-value: the null hypothesis is that all genetic variants estimate the same causal parameter; rejection of the null is an indication that one or more variants may be pleiotropic.}
}
\description{
The \code{mr_mvivwme} function performs multivariable Mendelian randomization via the inverse-variance method with measurement error.
}
\details{
The extension of multivariable Mendelian randomization to account for measurement error in the genetic associations with the exposure traits.
}
\examples{
mr_mvivwme(mr_mvinput(bx = cbind(ldlc, hdlc, trig), bxse = cbind(ldlcse, hdlcse, trigse),
   by = chdlodds, byse = chdloddsse))

}
\references{
Zhu, Jiazheng, Stephen Burgess, and Andrew J. Grant. Bias in Multivariable Mendelian Randomization Studies Due to Measurement Error on Exposures, 2022. https://doi.org/10.48550/arXiv.2203.08668.
}
