% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_lgcp.R
\name{lgcp_graph}
\alias{lgcp_graph}
\title{Create a log-Gaussian Cox process model for metric graphs}
\usage{
lgcp_graph(
  formula,
  graph,
  interpolate = TRUE,
  manual_integration_points = NULL,
  manual_covariates = NULL,
  use_current_mesh = TRUE,
  new_h = NULL,
  new_n = NULL,
  repl = ".all",
  repl_col = ".group",
  ...
)
}
\arguments{
\item{formula}{A formula object specifying the model structure}

\item{graph}{A metric_graph object containing the network and point pattern data}

\item{interpolate}{Logical; if TRUE, interpolate covariates from the graph data to integration points}

\item{manual_integration_points}{Data frame with columns edge_number, distance_on_edge, and E (integration weights)
for manually specified integration points, or NULL to use automatic integration points}

\item{manual_covariates}{Named vector of covariates at integration points if interpolate is FALSE and covariates are used}

\item{use_current_mesh}{Logical; if TRUE, use the existing mesh in the graph as integration points}

\item{new_h}{Numeric; mesh size for creating a new mesh if use_current_mesh is FALSE}

\item{new_n}{Integer; alternative to new_h, specifies the approximate number of mesh points}

\item{repl}{Vector of replicates to be used in the model. For all replicates, one must use ".all".}

\item{repl_col}{Name of the column in the data that contains the replicates. Default is ".group".}

\item{...}{Additional arguments to be passed to inla}
}
\value{
An object containing the fitted LGCP model
}
\description{
This function creates a log-Gaussian Cox process model for point pattern data on metric graphs.
It handles the creation of integration points and prepares the data for fitting with INLA.
}
