% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{.checkModelIntegrity}
\alias{.checkModelIntegrity}
\title{Model Integrity Checker}
\usage{
.checkModelIntegrity(model, verbose = TRUE)
}
\arguments{
\item{model}{the model to check.}

\item{verbose}{boolean indicating if the function is verbose, i.e. it indicates the different steps that it validates. If \code{FALSE}, only warnings and errors will be reported.}
}
\value{
No return value, called to check the integrity of a (new) model for the package (raises an error if the model is invalid).
}
\description{
Function to check the integrity of a given model. Used only for development.
}
\examples{
# Auto-run on package build
models = listAvailableModels()
for (model in models) {
  .checkModelIntegrity(model)
}
}
