% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{rotl_pq}
\alias{rotl_pq}
\title{rotl wrapper for phyloseq data}
\usage{
rotl_pq(
  physeq,
  taxonomic_rank = c("Genus", "Species"),
  context_name = "All life",
  discard_genus_alone = TRUE,
  pattern_to_remove_tip = c("ott\\\\d+|_ott\\\\d+"),
  pattern_to_remove_node = c("_ott.*|mrca*")
)
}
\arguments{
\item{physeq}{(required) a \code{\link[phyloseq]{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{taxonomic_rank}{(Character)
The column(s) present in the @tax_table slot of the phyloseq object. Can
be a vector of two columns (e.g. the default c("Genus", "Species")). If only
one column is set it need to be format in this way ("Genus species" for ex.
"Quercus robur") with a space.}

\item{context_name}{: can bue used to select only a part of the Open Tree
of Life. See \code{?rotl::tnrs_contexts()} for available values}

\item{discard_genus_alone}{(logical) If TRUE (default), genus without
information at the species level are discarded.}

\item{pattern_to_remove_tip}{(character regex string) A regex to remove
unwanted part of tip names. If set to null, tip names are left intact.}

\item{pattern_to_remove_node}{(character regex string) A regex to remove
unwanted part of node names. If set to null, node names are left intact.}
}
\value{
A plot
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-experimental-orange" alt="lifecycle-experimental"></a>
}}


Make a taxonomic tree using the ASV names of a physeq object and the
Open Tree of Life tree.
}
\details{
This function is mainly a wrapper of the work of others.
Please make a reference to \code{rotl} package if you
use this function.
}
\examples{
\dontshow{if (tolower(Sys.info()[["sysname"]]) != "windows") withAutoprint(\{ # examplesIf}
\donttest{
if (requireNamespace("rotl")) {
  tr <- rotl_pq(data_fungi_mini, pattern_to_remove_tip = NULL)
  plot(tr)

  tr_Asco <- rotl_pq(data_fungi,
    taxonomic_rank = c("Genus", "Species"),
    context_name = "Ascomycetes"
  )
  plot(tr_Asco)
}
}
\dontshow{\}) # examplesIf}
}
\author{
Adrien Taudière
}
