% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MittagLefflerDist.R
\name{Mittag-Leffler}
\alias{Mittag-Leffler}
\alias{dml}
\alias{pml}
\alias{qml}
\alias{rml}
\title{Distribution functions and random number generation.}
\usage{
dml(x, tail, scale = 1, log = FALSE, second.type = FALSE)

pml(q, tail, scale = 1, second.type = FALSE, lower.tail = TRUE, log.p = FALSE)

qml(p, tail, scale = 1, second.type = FALSE, lower.tail = TRUE, log.p = FALSE)

rml(n, tail, scale = 1, second.type = FALSE)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{tail}{tail parameter.}

\item{scale}{scale parameter.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{second.type}{logical; if FALSE (default), 
first type of Mittag-Leffler distribution is assumed.}

\item{lower.tail}{logical; if TRUE, probabilities are \eqn{P[X \le x]}
otherwise, \eqn{P[X > x]}}

\item{p}{vector of probabilities.}

\item{n}{number of random draws.}
}
\value{
\code{dml} returns the density,
        \code{pml} returns the distribution function,
        \code{qml} returns the quantile function, and
        \code{rml} generates random variables.
}
\description{
Probability density, cumulative distribution
function, quantile function and random variate generation for the
two types of Mittag-Leffler distribution.
The Laplace inversion algorithm by Garrappa is used for the pdf and 
cdf (see 
\url{https://www.mathworks.com/matlabcentral/fileexchange/48154-the-mittag-leffler-function}).
}
\details{
The Mittag-Leffler function \code{\link{mlf}} defines two types of 
probability distributions:

The \strong{first type} of Mittag-Leffler distribution assumes the Mittag-Leffler
function as its tail function, so that the CDF is given by
\deqn{F(q; \alpha, \tau) = 1 - E_{\alpha,1} (-(q/\tau)^\alpha)}
for \eqn{q \ge 0}, tail parameter \eqn{0 < \alpha \le 1},
and scale parameter \eqn{\tau > 0}.
Its PDF is given by
\deqn{f(x; \alpha, \tau) = x^{\alpha - 1} 
E_{\alpha,\alpha} [-(x/\tau)^\alpha] / \tau^\alpha.}
As \eqn{\alpha} approaches 1 from below, the Mittag-Leffler converges
(weakly) to the exponential
distribution. For \eqn{0 < \alpha < 1}, it is (very) heavy-tailed, i.e.
has infinite mean.

The \strong{second type} of Mittag-Leffler distribution is defined via the
Laplace transform of its density f:
\deqn{\int_0^\infty \exp(-sx) f(x; \alpha, 1) dx = E_{\alpha,1}(-s)}
It is light-tailed, i.e. all its moments are finite.
At scale \eqn{\tau}, its density is 
\deqn{f(x; \alpha, \tau) = f(x/\tau; \alpha, 1) / \tau.}
}
\examples{
dml(1, 0.8)
dml(1, 0.6, second.type=TRUE)
pml(2, 0.7, 1.5)
qml(p = c(0.25, 0.5, 0.75), tail = 0.6, scale = 100)
rml(10, 0.7, 1)

}
\references{
Haubold, H. J., Mathai, A. M., & Saxena, R. K. (2011). Mittag-Leffler
Functions and Their Applications. Journal of Applied Mathematics, 2011, 
1–51. \doi{10.1155/2011/298628}

Mittag-Leffler distribution. (2017, May 3).
In Wikipedia, The Free Encyclopedia.
\url{https://en.wikipedia.org/w/index.php?title=Mittag-Leffler_distribution&oldid=778429885}
}
\concept{Mittag Leffler Distribution}
