% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MittagLefflerFunc.R
\name{mlf}
\alias{mlf}
\title{Mittag-Leffler Function.}
\usage{
mlf(z, a, b = 1, g = 1)
}
\arguments{
\item{z}{The argument (real-valued)}

\item{a, b, g}{Parameters of the Mittag-Leffler distribution; see Garrappa}
}
\value{
\code{mlf} returns the value of the Mittag-Leffler function.
}
\description{
The generalized (two-parameter) Mittag-Leffer function is defined by the
power series
    \deqn{E_{\alpha,\beta} (z) = \sum_{k=0}^\infty  z^k / \Gamma(\alpha
    k + \beta) }
for complex \eqn{z} and complex \eqn{\alpha, \beta} with
\eqn{Real(\alpha) > 0} (only implemented for real valued parameters).
}
\examples{
mlf(2,0.7)
}
\references{
Garrappa, R. (2015). Numerical Evaluation of Two and Three Parameter
Mittag-Leffler Functions. SIAM Journal on Numerical Analysis, 53(3),
 1350–1369. \doi{10.1137/140971191}

The Mittag-Leffler function. MathWorks File Exchange.
\url{https://au.mathworks.com/matlabcentral/fileexchange/48154-the-mittag-leffler-function}
}
