% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2.main.R
\name{cov_mmcsd}
\alias{cov_mmcsd}
\title{Fit covariance structered longitudinal model.}
\usage{
cov_mmcsd(fit, fittingType, sigmaThetaExpr, optimParams)
}
\arguments{
\item{fit}{A fit model with class 'mmcsd'}

\item{fittingType}{A character with the fitting function type. See optins above}

\item{sigmaThetaExpr}{A character with the covariance structure type or a list of expressions}

\item{optimParams}{A list with configuration for optim function. 'Par' is required.}
}
\value{
The fit model with class 'mmcsd.theta'.
}
\description{
Responsible for performing the modeling of the model's covariance matrix through the use of covariance structures.
}
\examples{
\donttest{
fit <- mmcsd(
 score ~ wave + ageg + ecacg + qualifg,
 waves = wave, ids = id,
 weights = weight, stratum = strata, cluster = cluster,
 data = example_data, sigma = "exchangeable"
)
fitTheta_ucm <- cov_mmcsd(fit,
 fittingType = "PML", sigmaThetaExpr = "UCM",
 optimParams = list(par = c(7, 5))
)
}
}
