% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.plink.R
\name{get.plink}
\alias{get.plink}
\title{Generate binary plink-file}
\usage{
get.plink(
  population,
  path = NULL,
  database = NULL,
  gen = NULL,
  cohorts = NULL,
  id = NULL,
  chromosome = "all",
  non.genotyped.as.missing = FALSE,
  fam.id = FALSE,
  type = 0,
  use.id = TRUE,
  bve.pedigree.error = TRUE
)
}
\arguments{
\item{population}{Population list}

\item{path}{Location to save vcf-file}

\item{database}{Groups of individuals to consider for the export}

\item{gen}{Quick-insert for database (vector of all generations to export)}

\item{cohorts}{Quick-insert for database (vector of names of cohorts to export)}

\item{id}{Individual IDs to search/collect in the database}

\item{chromosome}{Limit the genotype output to a selected chromosome (default: "all")}

\item{non.genotyped.as.missing}{Set to TRUE to replaced non-genotyped entries with "./."}

\item{fam.id}{Set TRUE to set the fam-ID to the individual ID}

\item{type}{Set 1 to only write paternal haplotype, set 2 to only write maternal haplotype, set 0 for both (default)}

\item{use.id}{Set to TRUE to use MoBPS ids instead of Sex_Nr_Gen based names (default: TRUE)}

\item{bve.pedigree.error}{Set to FALSE to ignore/correct for any pedigree errors}
}
\value{
binary plink-file for in gen/database/cohorts selected individuals
}
\description{
Generate a binary plink-file for selected groups and chromosome
}
\examples{
data(ex_pop)
data(ex_pop)
\donttest{
file_path <- tempdir()
get.vcf(path=file_path, ex_pop, gen=2)
file.remove(paste0(file_path, ".vcf"))
}
}
