% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set.default.R
\name{set.default}
\alias{set.default}
\title{Set defaults}
\usage{
set.default(
  population,
  parameter.name = NULL,
  parameter.value = NULL,
  parameter.remove = NULL,
  reset.all = FALSE
)
}
\arguments{
\item{population}{Population list}

\item{parameter.name}{Number of traits (If more than traits via real.bv.X use traits with no directly underlying QTL)}

\item{parameter.value}{Genetic variance of traits with no underlying QTL}

\item{parameter.remove}{Remove a specific previously generated parameter default}

\item{reset.all}{Set to TRUE to remove all prior parameter values}
}
\value{
Population-list with one or more additional new traits
}
\description{
Set default parameter values in breeding.diploid
}
\examples{
data(ex_pop)
population <- set.default(ex_pop, parameter.name="heritability", parameter.value=0.3)
}
