% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcmodel.R
\name{calcmodel}
\alias{calcmodel}
\title{Calculate results of a single segmented regression model}
\usage{
calcmodel(x, scores, bps, cont = TRUE)
}
\arguments{
\item{x}{a \code{regions_pco} object; the output of a call to \code{svdPCO()}.}

\item{scores}{\code{numeric}; the indices of the PCO scores to use as the outcomes in fitting the model (e.g., \code{1:4} to use the first four scores).}

\item{bps}{\code{numeric}; the indices of the breakpoints to use in fitting the model. To request a model with no breakpoints, set to \code{NA}.}

\item{cont}{\code{logical}; whether to fit a model that is continuous (\code{TRUE}) or discontinuous (\code{FALSE}) at the breakpoints. Default is \code{TRUE}. Ignored when \code{bps} is \code{NA}.}
}
\value{
A \code{regions_results_single} object, which contains the results of the model (breakpoints and RSS of each PCO and overall) and model support statistics.
}
\description{
\code{calcmodel()} fits a multivariate segmented regression model using the supplied PCOs and breakpoints.
}
\examples{
data("alligator")

alligator_data <- process_measurements(alligator,
                                       pos = "Vertebra")

# Compute PCOs
alligator_PCO <- svdPCO(alligator_data)

# Calculate a single segmented regression model
# using first 2 PCOs and a discontinuous model
regionsmodel <- calcmodel(alligator_PCO,
                          scores = 1:3,
                          bps = c(8, 16, 21),
                          cont = FALSE)

regionsmodel

#Evaluate performance (R2) on that model
modelperf(regionsmodel)

#Plot model results:
plotsegreg(regionsmodel, scores = 1:3)
}
\seealso{
\code{\link[=calcregions]{calcregions()}} and \code{\link[=addregions]{addregions()}} for computing all possible models instead of just a single one; \code{\link[=plotsegreg]{plotsegreg()}}, for which the \code{plot} method is an alias, for plotting the fitted regression lines; \code{\link[=modelsupport]{modelsupport()}} for interpreting the model support statistics.
}
