% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svdPCO.R
\name{svdPCO}
\alias{svdPCO}
\title{Calculate PCO (principal co-ordinates analysis) based on SVD}
\usage{
svdPCO(x, metric = "gower", scale = TRUE)
}
\arguments{
\item{x}{a \code{regions_data} object; the output of a call to \code{\link[=process_measurements]{process_measurements()}}.}

\item{metric}{string; the distance matrix calculation metric. Allowable options include those support by \code{\link[cluster:daisy]{cluster::daisy()}}, which are \code{"euclidean"}, \code{"manhattan"}, or \code{"gower"}. Default is \code{"gower"}. Abbreviations allowed.}

\item{scale}{\code{logical}; whether to scale the variables prior to including them in the PCO estimation. Default is \code{TRUE}, which is especially advisable when using the bootstrap to select the number of PCOs to use in downstream analyses. Passed to the \code{stand} argument of \code{cluster::daisy()}. Ignored if \code{metric = "gower"}.}
}
\value{
A \code{regions_pco} object, which contains eigenvectors in the \code{scores} component and eigenvalues in the \code{eigen.val} component. The original dataset is stored in the \code{data} attribute.
}
\description{
Calculates distance matrix from raw data, then conducts a PCO ordination using a
single value decomposition (SVD). This differs from other PCO functions which use \code{\link[stats:cmdscale]{stats::cmdscale()}} and rely on a
spectral decomposition.
}
\examples{
data("alligator")

alligator_data <- process_measurements(alligator,
                                       pos = "Vertebra")

# Compute PCOs
alligator_PCO <- svdPCO(alligator_data,
                        metric = "gower")

alligator_PCO

# Plot PCOs against vertebra index
plot(alligator_PCO, pco_y = 1:2)

# Plot PCOs against each other
plot(alligator_PCO, pco_y = 1, pco_x = 2)
}
\seealso{
\code{\link[=plot.regions_pco]{plot.regions_pco()}} for plotting PCO axes

\code{\link[cluster:daisy]{cluster::daisy()}}, which is used to compute the distance matrix used in the calculation; \code{\link[stats:cmdscale]{stats::cmdscale()}} for a spectral decomposition-based implementation
}
