% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Main.R
\name{Muller.plot}
\alias{Muller.plot}
\title{Muller.plot}
\usage{
Muller.plot(
  attributes,
  population.data,
  data.method,
  time.interval.method = "linear",
  ...
)
}
\arguments{
\item{attributes}{A matrix or dataframe with two or three columns which contains information
about name, parent and color of OTUs. See details.}

\item{population.data}{a matrix or data frame which contains information about
population/abundance/frequency dynamics. See details.}

\item{data.method}{determines the method which is used for population.data. This must
be one of "list" or "table". See details of population.data.}

\item{time.interval.method}{determines the method which is used for scale of time/generation axis.
This must be one of "linear" or "equal". See details.}

\item{...}{Arguments to be passed as graphical parameters (see par).}
}
\value{
OTU names and corresponding colors will be returned.
}
\description{
Generates Muller plot from data of population/abundance/frequency dynamics and
parental/genealogy/phylogeny relation
}
\details{
attributes:

 First column (character or
 numeric) must contain OTU names, the second column (character or numeric) must contain
 parents of corresponding OTUs and the third column (optional) can contain colors of corresponding OTUs.
 The order of OTUs in the first column determines the order of sister OTUs (OTUs with the same parent)
 in the Muller plot. Those parents which are not present in the OTU list
 (first column) or in the population dynamics must be substituted by NA. At least one NA
 must exist in the second column. All the OTUs present in the rownames of population.data
 must exist in the first column of attributes (names). If third column is not provided, random color
 will be assigned to OTUs.

population.data:

When data.method is "list" population.data must have 3 columns. The first column
(character or numeric) contains OTU names. The second column (numeric) contains
times or generations. The third column (character) contains abundances of
corresponding OTU at corresponding time.
When data.method is "table" population.data must be an OTU table. rownames of
population.data must be OTU names and colnames of it must be times or
generations. Each column contains abundance of OTUs at that time/generation.

time.interval.method:

"linear" means that distances between subsequent time points on time/generation axis is
linear. "equal" means that regardless of the values in time/generation points, subsequent
time points have equal distance.
}
\examples{
 # load information of population/abundance/frequency dynamics as list
 data(PopulationDataList)
 # load attributes of OTUs (contains name, parent and color of OTUs)
 data(Attributes)
 # Muller plot
 Muller.plot(attributes = Attributes, population.data = PopulationDataList,data.method = "list",
             time.interval.method = "linear")

 # load information of population/abundance/frequency dynamics as table
 data(PopulationDataTable)
 # Muller plot
 Muller.plot(attributes = Attributes, population.data = PopulationDataTable,data.method = "table")

}
