% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/choose_B.R
\name{choose_B}
\alias{choose_B}
\title{Choose B for permutation tests}
\usage{
choose_B(p0 = 0.05, width = 0.01, conf.level = 0.95)
}
\arguments{
\item{p0}{A guess for the p-value. Can be based e.g. on a small number of simulations. The default is 0.05.}

\item{width}{The desired width of the Clopper-Pearson interval. The default is 0.01.}

\item{conf.level}{The confidence level of the Clopper-Pearson interval. The default is 0.95.}
}
\value{
B
}
\description{
Computes the value of B for a permutation test required to obtain a specified accuracy when
approximating the permutation p-values using B random permutations.
}
\details{
Computations are based on the Clopper-Pearson interval, using a formula from
Thulin (2014). The procedure is described in Section 3.3 in Persson et al. (2019).
}
\examples{
# B required to achieve an expected width of 0.02 when
# the p-value is approximately 0.1:
choose_B(p0 = 0.1, width = 0.02)

}
\references{
\insertRef{persson19}{MultSurvTests}

\insertRef{thulin14}{MultSurvTests}
}
