% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiObjMatch.R
\name{compare_tables}
\alias{compare_tables}
\title{Summarize covariate balance table}
\usage{
compare_tables(balance_table)
}
\arguments{
\item{balance_table}{a named list, which is the result from the function
\code{get_balance_table}}
}
\value{
a dataframe with combined information
}
\description{
This function would take the result of \code{get_balance_table}
function and combine the results in a single table. It only works for 'Basic'
version of the matching.
}
\examples{
## Generate matches
data("lalonde", package="cobalt")
ps_cols <- c("age", "educ", "married", "nodegree", "race")
treat_val <- "treat"
response_val <- "re78"  
pair_dist_val <- c("age", "married", "educ", "nodegree", "race")
my_bal_val <- c("race")
r1s <- c(0.01,1,2,4,4.4,5.2,5.4,5.6,5.8,6)
r2s <- c(0.001)
match_result <- dist_bal_match(data=lalonde, treat_col= treat_val, 
marg_bal_col = my_bal_val, exclusion_penalty=r1s, balance_penalty=r2s, 
dist_col = pair_dist_val, 
propensity_col = ps_cols, max_iter=0)

## Generate summary table for comparing matches 
compare_tables(get_balance_table(match_result))
}
