% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiObjMatch.R
\name{visualize}
\alias{visualize}
\title{Visualize tradeoffs}
\usage{
visualize(
  matching_result,
  x_axis = "dist1",
  y_axis = "dist2",
  z_axis = NULL,
  xlab = NULL,
  ylab = NULL,
  zlab = NULL,
  main = NULL,
  display_all = FALSE,
  cond = NULL,
  xlim = NULL,
  ylim = NULL,
  display_index = TRUE,
  average_cost = FALSE
)
}
\arguments{
\item{matching_result}{the matching result returned by either dist_bal_match or
two_dist_match.}

\item{x_axis}{character, naming the objective function shown on x-axis; one
of ("pair", "marginal", "dist1", "dist2", "exclude", "distance_penalty", "balance_penalty",
"dist1_penalty", "dist2_penalty", "exclusion_penalty"), "dist1" by default.}

\item{y_axis}{character, naming the objective function shown on y-axis; one
of ("pair", "marginal", "dist1", "dist2", "exclude", "distance_penalty", "balance_penalty",
"dist1_penalty", "dist2_penalty", "exclusion_penalty"), "dist1" by default.}

\item{z_axis}{character, naming the objective function for coloring; one
of ("pair", "marginal", "dist1", "dist2", "exclude"), "exclude" by default.}

\item{xlab}{(optional) the axis label for x-axis; NULL by default.}

\item{ylab}{(optional) the axis label for y-axis; NULL by default.}

\item{zlab}{(optional) the axis label for z-axis; NULL by default.}

\item{main}{(optional) the title of the graph; NULL by default.}

\item{display_all}{(optional) whether to show all the labels for match index;
FALSE by default, which indicates the visualization function only labels
matches at quantiles of number of treated units being excluded.}

\item{cond}{(optional) NULL by default, which denotes all the matches are
shown; otherwise, takes a list of boolean values indicating whether to
include each match}

\item{xlim}{(optional) NULL by default; function automatically takes the max
of the first objective function values being plotted on x-axis;
if specified otherwise, pass in the numeric vector
c(lower_bound, upper_bound)}

\item{ylim}{(optional) NULL by default; function automatically takes the max
of the first objective function values being plotted on y-axis;
if specified otherwise, pass in the numeric vector
c(lower_bound, upper_bound)}

\item{display_index}{(optional) TRUE by default; whether to display match
index}

\item{average_cost}{(optional) FALSE by default; whether to show mean cost}
}
\value{
No return value, called for visualization of match result
}
\description{
Main visualization functions for showing the tradeoffs between
two of the three objective functions. A 3-d plot can be visualized
where the third dimension is represented by coloring of the dots.
}
\details{
By default, the plotting function will show the tradeoff between
the first distance objective function and the marginal balance (if
dist_bal_match) is used; or simply the second distance objective function, if
two_dist_match is used.
}
