% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/MvBinaryEstim.R
\docType{package}
\name{MvBinary-package}
\alias{MvBinary}
\alias{MvBinary-package}
\title{MvBinary a package for Multivariate Binary data}
\description{
MvBinary is a tool for fitting the distribution of correlated multivariate binary data.
}
\details{
\tabular{ll}{
  Package: \tab MvBinary\cr
  Type: \tab Package\cr
  Version: \tab 1.0.0\cr
  Date: \tab 2015-11-03\cr
  License: \tab GPL-2\cr
  LazyLoad: \tab yes\cr
}
}
\examples{
# Package loading
rm(list=ls())
require(MvBinary)

# Data loading
data(MvBinaryExample)

# Parameter estimation by the HAC-based algorithm on 2 cores
# where the EM algorithms are initialized 10 times
res.CAH <- MvBinaryEstim(MvBinaryExample, 2, nbinit.EM = 10)

# Summary of the estimated model
summary(res.CAH)

# Print the parameters of the estimated model
print(res.CAH)
}
\author{
Author: Marbac M., and Sedki S.
}
\references{
Matthieu Marbac, Mohammed Sedki (2015). A Family of Blockwise One-Factor Distributions for Modelling High-Dimensional Binary Data. arXiv:1511.01343
}
\keyword{package}

