% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ae_attendances.R
\docType{data}
\name{ae_attendances}
\alias{ae_attendances}
\title{NHS England Accident & Emergency Attendances and Admissions}
\format{
Tibble with six columns
\describe{
\item{period}{The month that this data relates to}
\item{org_code}{The \href{https://digital.nhs.uk/services/organisation-data-service}{ODS} code for this provider}
\item{type}{The \href{https://web.archive.org/web/20200128111444/https://www.datadictionary.nhs.uk/data_dictionary/attributes/a/acc/accident_and_emergency_department_type_de.asp}{department type}.
            either 1, 2 or other}
\item{attendances}{the number of patients who attended this department in this month}
\item{breaches}{the number of patients who breaches the 4 hour target in this month}
\item{admissions}{the number of patients admitted from A&E to the hospital in this month}
}
}
\source{
\href{https://www.england.nhs.uk/statistics/statistical-work-areas/ae-waiting-times-and-activity/}{NHS England Statistical Work Areas}
}
\usage{
data(ae_attendances)
}
\description{
Reported attendances, 4 hour breaches and admissions for all A&E departments
in England for the years 2016/17 through 2018/19 (Apr-Mar). The data has been
tidied to be easily usable within the tidyverse of packages.
}
\details{
Data sourced from \href{https://www.england.nhs.uk/statistics/statistical-work-areas/ae-waiting-times-and-activity/}{NHS England Statistical Work Areas}
which is available under the \href{https://www.nationalarchives.gov.uk/doc/open-government-licence/version/3/}{Open Government Licence v3.0}
}
\examples{
data(ae_attendances)
library(dplyr)
library(ggplot2)
library(scales)

# Create a plot of the performance for England over time
ae_attendances \%>\%
  group_by(period) \%>\%
  summarise_at(vars(attendances, breaches), sum) \%>\%
  mutate(performance = 1 - breaches / attendances) \%>\%
  ggplot(aes(period, performance)) +
  geom_hline(yintercept = 0.95, linetype = "dashed") +
  geom_line() +
  geom_point() +
  scale_y_continuous(labels = percent) +
  labs(title = "4 Hour performance over time")

# Now produce a plot showing the performance of each trust
ae_attendances \%>\%
  group_by(org_code) \%>\%
  # select organisations that have a type 1 department
  filter(any(type == "1")) \%>\%
  summarise_at(vars(attendances, breaches), sum) \%>\%
  arrange(desc(attendances)) \%>\%
  mutate(performance = 1 - breaches / attendances,
         overall_performance = 1 - sum(breaches) / sum(attendances),
         rank = rank(-performance, ties.method = "first") / n()) \%>\%
  ggplot(aes(rank, performance)) +
  geom_vline(xintercept = c(0.25, 0.5, 0.75), linetype = "dotted") +
  geom_hline(yintercept = 0.95, colour = "red") +
  geom_hline(aes(yintercept = overall_performance), linetype = "dotted") +
  geom_point() +
  scale_y_continuous(labels = percent) +
  theme_minimal() +
  theme(panel.grid = element_blank(),
        axis.text.x = element_blank()) +
  labs(title = "4 Hour performance by trust",
       subtitle = "Apr-16 through Mar-19",
       x = "", y = "")

}
\keyword{a&e}
\keyword{datasets}
\keyword{hospital}
