% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SplitData.R
\name{SplitData}
\alias{SplitData}
\title{Split the data of each nanomaterial into different subsets of data}
\usage{
SplitData(data.nm, data.control, id, nano, dose, end, end.cat, unit,
  unit.cat, control.opt=c("same","all"), vars)
}
\arguments{
\item{data.nm}{Data containing the result of toxicity study}

\item{data.control}{Data of control values}

\item{id}{Identifier of the experiment}

\item{nano}{Name of the nanomaterial}

\item{dose}{Dose or concentration}

\item{end}{Toxicity endpoint}

\item{end.cat}{Specific toxicity endpoint of interest}

\item{unit}{Unit of measurement of the dose}

\item{unit.cat}{Specific unit of measurement of the dose}

\item{control.opt}{Option for the control doses if \code{unit} and
\code{unit.cat} are specified. If only control doses with the same unit of
measurement as the non-control ones are included, then specify
"\code{same}" in the \code{control.opt}. If all control doses with any
units of measurement are included, then specify "\code{all}".}

\item{vars}{Variables used to split the data}
}
\value{
This function splits the data of each nanomaterial into different
  subsets of data according to the unique values of selected variable(s)
}
\description{
This function splits the data of each nanomaterial into different subsets of
data according to the unique values of selected variable(s)
}
\examples{
# Example 1:
# Create a dataset containing controls (which are named differently)
# from geninvitro dataset:
controldata<-SubsetData(data=geninvitro, x="name", x.cat=c("control", "Control",
             "medium", "medium + BSA", "untreated"))

# Exclude controls (which are named differently) from geninvitro dataset:
invitrodata<-SubsetData(data=geninvitro, x="name", x.cat=c("control", "Control",
             "medium", "medium + BSA", "untreated"), include=FALSE)
#
# Split geninvitro data according to the cell type, method, study provider,
# unit of the concentration and the type of the endpoint:
datasub<-SplitData(data.nm=invitrodata, data.control=controldata,
                   id="experimentID", nano="name", dose="concentration",
                   vars=c("celltype", "method","studyprovider",
                   "concentration_unit","endpoint"))

# Example 2:
# Split geninvitro data with DNA STRAND BREAKS as the endpoint, according
# to the cell type, method, study provider, and unit of the concentration:
datasub2<-SplitData(data.nm=invitrodata, data.control=controldata,
                    id="experimentID", nano="name", dose="concentration",
                    end="endpoint", end.cat="DNA STRAND BREAKS",
                    vars=c("celltype","method","studyprovider",
                    "concentration_unit"))

# Example 3:
# Split geninvitro data with DNA STRAND BREAKS as the endpoint and
# concentration measured in ug/cm2, according to the cell type:
datasub3<-SplitData(data.nm=invitrodata, data.control=controldata,
                    id="experimentID", nano="name", dose="concentration",
                    end="endpoint", end.cat="DNA STRAND BREAKS",
                    unit="concentration_unit", unit.cat="ug/cm2",
                    control.opt="same", vars="celltype")
}
