% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmplot.cat.R
\name{nmplot.cat}
\alias{nmplot.cat}
\title{Create plots of the dose and the response grouped by a variable}
\usage{
nmplot.cat(data.nm, data.control, id, nano, response, dose, end,
  end.cat, unit, unit.cat, x.cat, type = c("dose", "log"), control.opt =
  c("same", "all"), vars, nrow = 1, ncol = 1)
}
\arguments{
\item{data.nm}{Data containing the result of toxicity study}

\item{data.control}{Data of control values}

\item{id}{Identifier of the experiment}

\item{nano}{Name of the nanomaterial}

\item{response}{Response (endpoint value)}

\item{dose}{Dose or concentration}

\item{end}{Toxicity endpoint}

\item{end.cat}{Specific toxicity endpoint of interest}

\item{unit}{Unit of measurement of the dose}

\item{unit.cat}{Specific unit of measurement of the dose}

\item{x.cat}{Variable used to differentiate the colour of the
data points in the plot(s)}

\item{type}{Type of the dose to be plotted ("\code{dose}" for dose and
"\code{log}" for log(dose))}

\item{control.opt}{Option for the control doses if \code{unit} and
\code{unit.cat} are specified. If only control doses with
the same unit of measurement as the non-control ones are included, then
specify "\code{same}" in the \code{control.opt}. If all control doses with
any units of measurement are included, then specify "\code{all}".}

\item{vars}{Variable(s) used to subset the data}

\item{nrow}{Number of rows in the plotting space (default is 1)}

\item{ncol}{Number of columns in the plotting space (default is 1)}
}
\value{
This function produces scatter plots of the dose and the response,
  grouped by a certain variable
}
\description{
This function generates scatter plots of the dose and the response, with the
colour of the data points differentiated according to the value of a
variable.
}
\details{
\itemize{
\item{This function generates plots for each nanomaterial in the dataset (or
for each subset of data). The different types of nanomaterials are identified
by their names. Therefore, if some control values are named differently (see:
\code{\link{geninvitro}} dataset and the \code{Examples}), a separate dataset
containing only these values first needs to be created. Controls in the new
dataset can be linked to the non-control observations belonging to the same
experiment through the identifier of the experiment (the linking is performed
inside this function). In this situation, it is necessary to have an
indicator that can identify different experiments (such as experiment ID).}
\item{If all controls in the dataset are named according to the related
nanomaterial names, \code{data.control} and \code{id} do not need to be
specified.}
\item{If doses used in the experiment are all measured in the same unit of
measurement, then specify "\code{same}" in \code{control.opt}}.
\item{Dose-response plot can also be generated for subsets of data in each
nanomaterial by specifying the variables used to split the data in
\code{vars}}.
}
}
\examples{
# Example 1:
# Create a dataset containing controls (which are named differently)
# from geninvitro dataset:
controldata<-SubsetData(data=geninvitro, x="name", x.cat=c("control", "Control",
             "medium", "medium + BSA", "untreated"))

# Exclude controls (which are named differently) from geninvitro dataset:
invitrodata<-SubsetData(data=geninvitro, x="name", x.cat=c("control", "Control",
             "medium", "medium + BSA", "untreated"), include=FALSE)

# Generate dose-response plots for geninvitro, with DNA STRAND BREAKS as
# the endpoint, concentrations measured in "ug/cm2" and control doses
# measured in any units of measurement (different colours represent different
# study providers):
#
\donttest{nmplot.cat(data.nm=invitrodata, data.control=controldata, id="experimentID",
           nano="name", response="value", dose="concentration", end="endpoint",
           end.cat="DNA STRAND BREAKS", unit="concentration_unit", unit.cat="ug/cm2",
           x.cat="studyprovider", type="dose", control.opt="all",
           nrow=1, ncol=1)}

# Example 2:
# Split geninvitro data according to the method, study provider and unit of
# the concentration, and generate dose-response plot for each subset of data
# with DNA STRAND BREAKS as the endpoint (different colours represent
# different cell types):
#
\donttest{nmplot.cat(data.nm=invitrodata, data.control=controldata, id="experimentID",
           nano="name", response="value", dose="concentration", end="endpoint",
           end.cat="DNA STRAND BREAKS",  x.cat="celltype", type="dose",
           vars=c("method","studyprovider","concentration_unit"),
           nrow=2, ncol=2)}
}
