% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/densprf.R
\name{densprf}
\alias{densprf}
\title{Density Estimation Function}
\usage{
densprf(
  x,
  n.interval = NULL,
  df = 5,
  knots.mode = TRUE,
  type.nclass = c("wand", "scott", "FD"),
  addx = FALSE
)
}
\arguments{
\item{x}{Input data vector.}

\item{n.interval}{Number of intervals (optional).}

\item{df}{Degrees of freedom for the splines.}

\item{knots.mode}{Boolean to determine if quantiles should be used for knots.}

\item{type.nclass}{Method for determining number of classes.}

\item{addx}{Add \eqn{x} values (optional).}
}
\value{
The function \code{densprf(x)} returns a function that, for a given input \code{z}, computes the estimated density evaluated at the position values of \code{z} as a result.
}
\description{
This function estimates the density using a Poisson GLM with natural splines.
}
\details{
\code{densprf} is a modification of the \code{denspr} function from the \strong{siggenes} package.

For more details, see the documentation in the \strong{siggenes} package.
}
\examples{
# Set seed for reproducibility
set.seed(123)

# Generate random data
z <- rnorm(1000)

# Apply densprf function
f <- densprf(z)

# Define sequences for evaluation
x1 <- seq(-4, 4, 0.5)
x2 <- seq(-5, 5, 0.1)

# Evaluate the density function at specified points
f1 <- f(x1)
f2 <- f(x2)
}
