% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcoa.R
\name{runPCoA}
\alias{runPCoA}
\alias{runPCoA.data.frame}
\alias{runPCoA.matrix}
\alias{runPCoA.default}
\title{Principal Coordinates Analysis (PCoA) Analysis}
\usage{
runPCoA(
  data,
  group,
  k = 2,
  distance = "bray",
  adonis2 = TRUE,
  anosim = TRUE,
  simper = TRUE,
  ...
)

\method{runPCoA}{data.frame}(
  data,
  group,
  k = 2,
  distance = "bray",
  adonis2 = TRUE,
  anosim = TRUE,
  simper = TRUE,
  ...
)

\method{runPCoA}{matrix}(
  data,
  group,
  k = 2,
  distance = "bray",
  adonis2 = TRUE,
  anosim = TRUE,
  simper = TRUE,
  ...
)

\method{runPCoA}{default}(
  data,
  group,
  k = 2,
  distance = "bray",
  adonis2 = TRUE,
  anosim = TRUE,
  simper = TRUE,
  ...
)
}
\arguments{
\item{data}{\code{data.frame} or \code{matrix}. The nematode abundance table where rows represent samples and columns represent nematode genera.
Each element indicates the count of a specific nematode genus in the corresponding sample. Row names must be sample names.}

\item{group}{\code{data.frame}. A data frame with sample names as row names and a single column containing group information for each sample.}

\item{k}{Number of dimensions for PCoA (default: 2).}

\item{distance}{Distance metric to use (default: "bray"). See \code{\link[vegan]{vegdist}} for all available options.}

\item{adonis2}{Logical; whether to perform PERMANOVA test using \code{\link[vegan]{adonis2}} (default: TRUE).}

\item{anosim}{Logical; whether to perform ANOSIM test using \code{\link[vegan]{anosim}} (default: TRUE).}

\item{simper}{Logical; whether to perform SIMPER test using \code{\link[vegan]{simper}} (default: TRUE).}

\item{...}{Additional arguments passed to \code{\link[stats]{cmdscale}}, \code{\link[vegan]{decostand}}, \code{\link[vegan]{adonis2}}, \code{\link[vegan]{anosim}}, or \code{\link[vegan]{simper}}.}
}
\value{
An object of class "PCoA" containing:
\itemize{
\item data - List containing the input data and group information
\item call - The function call
\item Points - Sample coordinates in the reduced space.
\item Eigenvalues - Variance explained by each principal coordinate axis.
\item adonis2 - PERMANOVA results (if adonis2 = TRUE)
\item anosim - ANOSIM results (if anosim = TRUE)
\item SIMPER - SIMPER results (if simper = TRUE)
}
}
\description{
This function performs PCoA analysis on a dataset using the specified distance metric,
and optionally runs PERMANOVA (adonis2) and ANOSIM tests for group differences.
It supports both data.frame and matrix inputs.
}
\examples{
# Example with default Bray-Curtis distance
data <- data.frame(
  Cephalobus = c(10, 20, 30, 1, 6, 5),
  Eucephalobus = c(5, 10, 12, 30, 1, 6),
  Acrobeloides = c(1, 2, 3, 12, 30, 1),
  Caenorhabditis = c(5, 8, 15, 2, 3, 12),
  Aphelenchus = c(5, 13, 11, 15, 2, 3),
  Leptonchus = c(3, 10, 15, 0, 15, 11),
  Pratylenchus = c(9, 2, 15, 15, 0, 15),
  Tylenchus = c(5, 0, 15, 11, 15, 2),
  Mesodorylaimus = c(7, 10, 18, 3, 12, 30),
  Discolaimus = c(1, 10, 25, 10, 18, 3),
  row.names = c("Sample1", "Sample2", "Sample3", "Sample4", "Sample5", "Sample6")
)
group_df <- data.frame(
  group = c("A", "A", "B", "B", "C", "C"),
  row.names = c("Sample1", "Sample2", "Sample3", "Sample4", "Sample5", "Sample6")
)

pcoa <- runPCoA(data, group = group_df)

}
\seealso{
\itemize{
\item \code{\link[stats]{cmdscale}} for details on cmdscale implementation
\item \code{\link[vegan]{vegdist}} for available distance metrics
\item \code{\link[vegan]{adonis2}} for PERMANOVA
\item \code{\link[vegan]{anosim}} for ANOSIM
\item \code{\link[vegan]{simper}} for SIMPER
}
}
