% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NBSI2.R
\name{NBSI2}
\alias{NBSI2}
\title{Niche-model-Based Species Identification (NBSI) for a prior analysis}
\usage{
NBSI2(
  ref.infor = NULL,
  que.infor = NULL,
  ref.env = NULL,
  que.env = NULL,
  barcode.identi.result,
  model = "RF",
  variables = "ALL",
  en.vir = NULL,
  bak.vir = NULL
)
}
\arguments{
\item{ref.infor}{Data frame, reference dataset containing sample IDs, taxon
information,longitude and latitude of each sample.}

\item{que.infor}{Data frame, query samples,containing sample IDs,longitude
and latitude of each sample.}

\item{ref.env}{Data frame,containing reference sampleIDs, species names,
and a set of environmental variables collected by users.}

\item{que.env}{Data frame,containing query sampleIDs,and a set of
corresponding environmental variables collected by users.}

\item{barcode.identi.result}{Data frame, species identifications by other
methods or barocodes, containing query IDs, species identified, and
corresponding probabilities.}

\item{model}{Character, string indicating which niche model will be used.
Must be one of "RF" (default) or "MAXENT". "MAXENT" can only be applied when
the java program paste(system.file(package="dismo"), "/java/maxent.jar",
sep='') exists.}

\item{variables}{Character, the identifier of selected bioclimate variables.
Default of "ALL" represents to use all the layers in en.vir; the alternative
option of "SELECT" represents to randomly remove the highly-correlated
variables (|r| larger than 0.9) with the exception of one layer.}

\item{en.vir}{RasterBrick, the global bioclimate data output from
"raster::getData" function.}

\item{bak.vir}{Matrix, bioclimate variables of random background points.}
}
\value{
A dataframe of identifications for query samples and their
niche-based reliability.
}
\description{
If users already have species identified by other barcodes or
methods, they can use this function given the identified species names
and corresponding probabilities to make further confirm by environmental
niche model.
}
\examples{
data(en.vir)
data(bak.vir)
#envir<-raster::getData("worldclim",download=FALSE,var="bio",res=2.5)
#en.vir<-raster::brick(envir)
#back<-dismo::randomPoints(mask=en.vir,n=5000,ext=NULL,extf=1.1,
#                          excludep=TRUE,prob=FALSE,
#                          cellnumbers=FALSE,tryf=3,warn=2,
#                          lonlatCorrection=TRUE)
#bak.vir<-raster::extract(en.vir,back)

data(LappetMoths)
barcode.identi.result<-LappetMoths$barcode.identi.result
ref.infor<-LappetMoths$ref.infor
que.infor<-LappetMoths$que.infor

if(class(en.vir) == "NULL"){
 NBSI2.out<-NBSI2(ref.infor=ref.infor,que.infor=que.infor,
                  barcode.identi.result=barcode.identi.result,
                  model="RF",variables="SELECT",
                  en.vir=NULL,bak.vir=NULL)
}else{
 NBSI2.out<-NBSI2(ref.infor=ref.infor,que.infor=que.infor,
                  barcode.identi.result=barcode.identi.result,
                  model="RF",variables="SELECT",
                  en.vir=en.vir,bak.vir=bak.vir)
}
NBSI2.out

ref.env<-LappetMoths$ref.env
que.env<-LappetMoths$que.env

NBSI2.out2<-NBSI2(ref.env=ref.env,que.env=que.env,
                  barcode.identi.result=barcode.identi.result,
                  model="RF",variables="ALL",
                  en.vir=en.vir,bak.vir=bak.vir)
NBSI2.out2
}
\references{
Breiman, L. 2001. Random forests. Machine Learning 45(1):5-32.

Liaw, A. and M. Wiener. 2002. Clasification and regression by
randomForest. R News, 2/3:18-22.

Phillips, S.J., R.P. Anderson and R.E. Schapire. 2006. Maximum
entropy modeling of species geographic distributions. Ecological Modelling,
190:231-259.

Hijmans, R.J., S.E. Cameron, J.L. Parra, P.G. Jones and A. Jarvis.
2005. Very high resolution interpolated climate surfaces for global land areas.
International Journal of Climatology, 25(15):1965-1978.
}
\author{
Cai-qing YANG (Email: yangcq_ivy(at)163.com) and Ai-bing ZHANG
(Email:zhangab2008(at)cnu.edu.cn), Capital Normal University (CNU), Beijing,
CHINA.
}
\keyword{NBSI2}
