% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/NostalgiR.R
\name{nos.hist}
\alias{nos.hist}
\title{nos.hist text-based plot of a histogram.}
\usage{
nos.hist(data, breaks = "Sturges", freq = T, xlab = NULL, ratio = 0.25,
  width = round(options()$width * 0.8), height = round(ratio * width),
  pch = "o")
}
\arguments{
\item{data}{A numeric vector containing the values to be plotted. \code{NA} and \code{NaN} are allowed, but are removed for the plot. Infinities will cause an error.}

\item{breaks}{Either a numerical value or a character string to specify the number of breaks to used. The default setting is \code{'Sturges'}, which is the default option in \code{\link[graphics]{hist}}; see \code{\link[graphics]{hist}} for other options.}

\item{freq}{If \code{TRUE}, the y-coordinate will display frequencies. If \code{FALSE}, then the y-coordinate will display densities.}

\item{xlab}{Label of the x-axis of the plot.}

\item{ratio}{Coefficient that controls the aspect ratio of the plot.}

\item{width}{Width of the plot in points.}

\item{height}{Height of the plot in points.}

\item{pch}{A single-character plot symbol.}
}
\description{
Plots a text-based of a histogram, with the option to plot densities or frequencies.
}
\note{
Due to rounding to a relatively crude grid results can only be approximate. The equally spaced axis ticks, for example, may be non-equally spaced in the plot. Further, due to the crude grid also there might be several points per character. The function uses the same plotting symbol no matter how many points coincide on one character position. Histogram columns are plotted at the midpoint of each bin.
}
\examples{
## Plot a histogram for the frequencies of 100 random standard normal points
## using 'Sturges' breaks and plot symbol 'o'.
data <- rnorm(100)
nos.hist(data)

## Plot a histogram for the densities of 1000 random chi-squared(3) points
## using 'FD' breaks and plot symbol '#'.
data <- rchisq(1000,3)
nos.hist(data,breaks='FD',freq=FALSE,pch='#')
}
\author{
Hien D. Nguyen
}
\seealso{
\code{\link[graphics]{hist}}, and \code{\link[txtplot]{txtplot}}.
}

