% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel.g.density.R
\name{kernel.g.density}
\alias{kernel.g.density}
\title{Gaussian kernel density estimation}
\usage{
kernel.g.density(data, points, h)
}
\arguments{
\item{data}{vector of observations}

\item{points}{in which the function is evaluated}

\item{h}{bandwidth}
}
\value{
density estimation
}
\description{
Estimates the density function using the Gaussian kernel
}
\examples{
x = rnorm(100,1,2)
gridd = seq(-5,5,length.out=1000)
h = (4/3)^(1/5)*sd(x)*length(x)^(-1/5)
kernel.g.density (x,gridd,h)
}
