% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manual_data_collection_program.R
\name{manual_data_collection_program}
\alias{manual_data_collection_program}
\title{Manually Collect Direct Observation Data}
\usage{
manual_data_collection_program(
  id,
  timestamps,
  activities,
  durations = NULL,
  seated = NA,
  large_muscles_moving = NA,
  slow = NA,
  slowed_by_resistance = NA,
  ambulation = NA,
  light_walking = NA
)
}
\arguments{
\item{id}{Character scalar giving ID to assign to the trial}

\item{timestamps}{Vector of times (character or POSIX) corresponding to onset of each activity and (if \code{durations = NULL}) offset of the final activity (i.e., ending time of the trial)}

\item{activities}{Character vector of activities in the sequence they were performed}

\item{durations}{Optional numeric vector giving duration of each activity, in seconds}

\item{seated}{Character vector giving yes/no/NA response for whether the participant was seated during each activity}

\item{large_muscles_moving}{Character vector giving yes/no/NA response for whether the participant was moving large muscles during each activity}

\item{slow}{Character vector giving yes/no/NA response for whether muscle contractions were slow during each activity}

\item{slowed_by_resistance}{Character vector giving yes/no/NA response for whether slow muscle contractions were slowed because of resistance}

\item{ambulation}{Character vector giving yes/no/NA response for whether the each activity is ambulatory}

\item{light_walking}{Character vector giving yes/no/NA response for whether ambulation was slow enough to be considered light activity instead of moderate or vigorous}
}
\value{
A dataframe of pre-processed direct observation data generated
    from minimal input
}
\description{
Manually Collect Direct Observation Data
}
\note{
By default, activity duration is automatically calculated, which is accomplished via \code{\link[base]{diff.POSIXt}} and thus requires \code{n + 1} timestamps, where \code{n} is the number of activities. Alternatively, durations can be manually specified via the \code{durations} parameter, in which case only \code{n} timestamps are needed, corresponding to the onset of each activity.
}
\seealso{
Other collection functions: 
\code{\link{data_collection_program}()},
\code{\link{interactive_data_collection_program}()}
}
\concept{collection functions}
\keyword{internal}
